/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.nbt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class NBTHelper {
    public static IntArrayTag serializeBoundingBox(BoundingBox box) {
        return new IntArrayTag(new int[]{box.m_162395_(), box.m_162396_(), box.m_162398_(), box.m_162399_(), box.m_162400_(), box.m_162401_()});
    }

    public static BoundingBox deserializeBoundingBox(int[] v) {
        return new BoundingBox(v[0], v[1], v[2], v[3], v[4], v[5]);
    }

    public static CompoundTag serializeBlockPos(BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("posX", pos.m_123341_());
        tag.m_128405_("posY", pos.m_123342_());
        tag.m_128405_("posZ", pos.m_123343_());
        return tag;
    }

    public static BlockPos deserializeBlockPos(CompoundTag tag) {
        int x = tag.m_128451_("posX");
        int y = tag.m_128451_("posY");
        int z = tag.m_128451_("posZ");
        return new BlockPos(x, y, z);
    }

    public static <T, N extends Tag> Map<UUID, T> readMap(CompoundTag nbt, String name, Class<N> nbtType, Function<N, T> mapper) {
        HashMap<UUID, T> res = new HashMap<UUID, T>();
        ListTag uuidList = nbt.m_128437_(name + "Keys", 8);
        ListTag valuesList = (ListTag)nbt.m_128423_(name + "Values");
        if (uuidList.size() != valuesList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < uuidList.size(); ++i) {
            res.put(UUID.fromString(uuidList.get(i).m_7916_()), mapper.apply(valuesList.get(i)));
        }
        return res;
    }

    public static <T, N extends Tag> void writeMap(CompoundTag nbt, String name, Map<UUID, T> map, Class<N> nbtType, Function<T, N> mapper) {
        ListTag uuidList = new ListTag();
        ListTag valuesList = new ListTag();
        map.forEach((key, value) -> {
            uuidList.add((Object)StringTag.m_129297_((String)key.toString()));
            valuesList.add((Object)((Tag)mapper.apply(value)));
        });
        nbt.m_128365_(name + "Keys", (Tag)uuidList);
        nbt.m_128365_(name + "Values", (Tag)valuesList);
    }

    public static <T, N extends Tag> List<T> readList(CompoundTag nbt, String name, Class<N> nbtType, Function<N, T> mapper) {
        return NBTHelper.readCollection(nbt, name, nbtType, mapper, new ArrayList());
    }

    public static <T, N extends Tag> Set<T> readSet(CompoundTag nbt, String name, Class<N> nbtType, Function<N, T> mapper) {
        return NBTHelper.readCollection(nbt, name, nbtType, mapper, new HashSet());
    }

    public static <T, C extends Collection<T>, N extends Tag> C readCollection(CompoundTag nbt, String name, Class<N> nbtType, Function<N, T> mapper, C collection) {
        ListTag listNBT = (ListTag)nbt.m_128423_(name);
        for (Tag inbt : listNBT) {
            collection.add(mapper.apply(inbt));
        }
        return collection;
    }

    public static <T, N extends Tag> void writeCollection(CompoundTag nbt, String name, Collection<T> list, Class<N> nbtType, Function<T, N> mapper) {
        ListTag listNBT = new ListTag();
        list.forEach(item -> listNBT.add((Object)((Tag)mapper.apply(item))));
        nbt.m_128365_(name, (Tag)listNBT);
    }

    public static <T> void writeOptional(CompoundTag nbt, String key, @Nullable T object, BiConsumer<CompoundTag, T> writer) {
        nbt.m_128379_(key + "_present", object != null);
        if (object != null) {
            CompoundTag write = new CompoundTag();
            writer.accept(write, (CompoundTag)object);
            nbt.m_128365_(key, (Tag)write);
        }
    }

    @Nullable
    public static <T> T readOptional(CompoundTag nbt, String key, Function<CompoundTag, T> reader) {
        return NBTHelper.readOptional(nbt, key, reader, null);
    }

    @Nullable
    public static <T> T readOptional(CompoundTag nbt, String key, Function<CompoundTag, T> reader, T _default) {
        if (nbt.m_128471_(key + "_present")) {
            CompoundTag read = nbt.m_128469_(key);
            return reader.apply(read);
        }
        return _default;
    }

    public static ListTag serializeSimpleContainer(SimpleContainer ct) {
        ListTag list = new ListTag();
        for (int slot = 0; slot < ct.m_6643_(); ++slot) {
            ItemStack stack = ct.m_8020_(slot);
            if (stack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("slot", slot);
            tag.m_128365_("stack", (Tag)stack.serializeNBT());
            list.add((Object)tag);
        }
        return list;
    }

    public static void deserializeSimpleContainer(SimpleContainer ct, ListTag list) {
        ct.m_6211_();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            int slot = tag.m_128451_("slot");
            ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack"));
            if (stack.m_41619_()) continue;
            ct.m_6836_(slot, stack);
        }
    }
}

