/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.damage;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.PlayerDamageMultiplierMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class PlayerDamageHelper {
    private static final Map<UUID, Map<UUID, DamageMultiplier>> multipliers = new HashMap<UUID, Map<UUID, DamageMultiplier>>();

    public static DamageMultiplier applyMultiplier(UUID id, ServerPlayer player, float value, Operation operation) {
        return PlayerDamageHelper.applyMultiplier(id, player, value, operation, true);
    }

    public static DamageMultiplier applyMultiplier(UUID id, ServerPlayer player, float value, Operation operation, boolean showOnClient) {
        return PlayerDamageHelper.applyMultiplier(id, player, value, operation, showOnClient, sPlayer -> {});
    }

    public static DamageMultiplier applyMultiplier(UUID id, ServerPlayer player, float value, Operation operation, boolean showOnClient, Consumer<ServerPlayer> onTimeout) {
        return PlayerDamageHelper.apply(player.m_20194_(), player.m_142081_(), new DamageMultiplier(id, player.m_142081_(), value, operation, showOnClient, Integer.MAX_VALUE, onTimeout));
    }

    public static DamageMultiplier applyTimedMultiplier(ServerPlayer player, float value, Operation operation, boolean showOnClient, int tickDuration) {
        return PlayerDamageHelper.applyTimedMultiplier(PlayerDamageHelper.findFreeMultiplierId(player), player, value, operation, showOnClient, tickDuration);
    }

    public static DamageMultiplier applyTimedMultiplier(UUID id, ServerPlayer player, float value, Operation operation, boolean showOnClient, int tickDuration) {
        return PlayerDamageHelper.applyTimedMultiplier(player, value, operation, showOnClient, tickDuration, sPlayer -> {});
    }

    public static DamageMultiplier applyTimedMultiplier(ServerPlayer player, float value, Operation operation, boolean showOnClient, int tickDuration, Consumer<ServerPlayer> onTimeout) {
        return PlayerDamageHelper.applyTimedMultiplier(PlayerDamageHelper.findFreeMultiplierId(player), player, value, operation, showOnClient, tickDuration, onTimeout);
    }

    public static DamageMultiplier applyTimedMultiplier(UUID id, ServerPlayer player, float value, Operation operation, boolean showOnClient, int tickDuration, Consumer<ServerPlayer> onTimeout) {
        return PlayerDamageHelper.apply(player.m_20194_(), player.m_142081_(), new DamageMultiplier(id, player.m_142081_(), value, operation, showOnClient, tickDuration, onTimeout));
    }

    private static UUID findFreeMultiplierId(ServerPlayer player) {
        UUID freeId;
        while (PlayerDamageHelper.getMultiplier(player, freeId = UUID.randomUUID()) != null) {
        }
        return freeId;
    }

    private static DamageMultiplier apply(MinecraftServer srv, UUID playerId, DamageMultiplier multiplier) {
        multipliers.computeIfAbsent(playerId, id -> new HashMap()).put(multiplier.id, multiplier);
        multiplier.removed = false;
        PlayerDamageHelper.sync(srv, playerId);
        return multiplier;
    }

    public static boolean hasMultiplier(ServerPlayer player, UUID id) {
        return multipliers.getOrDefault(player.m_142081_(), Collections.emptyMap()).containsKey(id);
    }

    @Nullable
    public static DamageMultiplier getMultiplier(ServerPlayer player, UUID id) {
        return (DamageMultiplier)multipliers.getOrDefault(player.m_142081_(), Collections.emptyMap()).get(id);
    }

    public static boolean removeMultiplier(ServerPlayer player, DamageMultiplier multiplier) {
        return PlayerDamageHelper.removeMultiplier(player.m_20194_(), player.m_142081_(), multiplier);
    }

    public static boolean removeMultiplier(ServerPlayer player, UUID modifierId) {
        return PlayerDamageHelper.removeMultiplier(player.m_20194_(), player.m_142081_(), modifierId);
    }

    public static boolean removeMultiplier(MinecraftServer srv, UUID playerId, DamageMultiplier multiplier) {
        return PlayerDamageHelper.removeMultiplier(srv, playerId, multiplier.id);
    }

    public static boolean removeMultiplier(MinecraftServer srv, UUID playerId, UUID modifierId) {
        DamageMultiplier removed = (DamageMultiplier)multipliers.getOrDefault(playerId, Collections.emptyMap()).remove(modifierId);
        if (removed != null) {
            removed.removed = true;
            PlayerDamageHelper.sync(srv, playerId);
        }
        return removed != null;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        PlayerDamageHelper.multipliers.forEach((playerId, multipliers) -> {
            ServerPlayer sPlayer = srv.m_6846_().m_11259_(playerId);
            if (sPlayer == null) {
                return;
            }
            ArrayList toRemove = new ArrayList();
            multipliers.forEach((id, multiplier) -> {
                multiplier.tick();
                if (multiplier.shouldRemove()) {
                    multiplier.onTimeout.accept(sPlayer);
                    multiplier.removed = true;
                    toRemove.add(id);
                }
            });
            toRemove.forEach(multipliers::remove);
            if (!toRemove.isEmpty()) {
                PlayerDamageHelper.sync(srv, playerId);
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingHurtEvent event) {
        Entity source = event.getSource().m_7639_();
        if (source instanceof ServerPlayer) {
            event.setAmount(event.getAmount() * PlayerDamageHelper.getDamageMultiplier((Player)((ServerPlayer)source), true));
        }
    }

    @SubscribeEvent
    public static void on(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerDamageHelper.sync(player2);
        }
    }

    public static float getDamageMultiplier(Player player, boolean ignoreClientFlag) {
        return PlayerDamageHelper.getDamageMultiplier(player.m_142081_(), ignoreClientFlag);
    }

    private static float getDamageMultiplier(UUID playerId, boolean ignoreClientFlag) {
        Collection damageMultipliers = multipliers.getOrDefault(playerId, Collections.emptyMap()).values();
        float multiplier = 1.0f;
        for (DamageMultiplier mult : damageMultipliers) {
            if (!ignoreClientFlag && !mult.showOnClient || mult.operation != Operation.ADDITIVE_MULTIPLY) continue;
            multiplier += mult.value;
        }
        for (DamageMultiplier mult : damageMultipliers) {
            if (!ignoreClientFlag && !mult.showOnClient || mult.operation != Operation.STACKING_MULTIPLY) continue;
            multiplier *= mult.value;
        }
        return Math.max(multiplier, 0.0f);
    }

    public static void syncAll(MinecraftServer srv) {
        multipliers.keySet().forEach(playerId -> PlayerDamageHelper.sync(srv, playerId));
    }

    public static void sync(MinecraftServer srv, UUID playerId) {
        ServerPlayer sPlayer = srv.m_6846_().m_11259_(playerId);
        if (sPlayer != null) {
            PlayerDamageHelper.sync(sPlayer);
        }
    }

    public static void sync(ServerPlayer sPlayer) {
        float multiplier = PlayerDamageHelper.getDamageMultiplier((Player)sPlayer, false);
        ModNetwork.CHANNEL.sendTo((Object)new PlayerDamageMultiplierMessage(multiplier), sPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static enum Operation {
        ADDITIVE_MULTIPLY,
        STACKING_MULTIPLY;

    }

    public static class DamageMultiplier {
        private final UUID id;
        private final UUID playerId;
        private final float value;
        private final Operation operation;
        private final boolean showOnClient;
        private final int originalTimeout;
        private int tickTimeout;
        private final Consumer<ServerPlayer> onTimeout;
        private boolean removed = false;

        private DamageMultiplier(UUID id, UUID playerId, float value, Operation operation, boolean showOnClient, int tickTimeout, Consumer<ServerPlayer> onTimeout) {
            this.id = id;
            this.playerId = playerId;
            this.value = value;
            this.operation = operation;
            this.showOnClient = showOnClient;
            this.originalTimeout = tickTimeout;
            this.tickTimeout = tickTimeout;
            this.onTimeout = onTimeout;
        }

        public float getMultiplier() {
            return this.value;
        }

        private boolean shouldRemove() {
            return this.tickTimeout < 0;
        }

        public void refreshDuration(MinecraftServer srv) {
            if (this.removed) {
                PlayerDamageHelper.apply(srv, this.playerId, this);
            }
            this.tickTimeout = this.originalTimeout;
        }

        private void tick() {
            if (this.tickTimeout != Integer.MAX_VALUE) {
                --this.tickTimeout;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DamageMultiplier that = (DamageMultiplier)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

