/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.damage;

import iskallia.vault.event.ActiveFlags;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.util.damage.DamageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DamageOverTimeHelper {
    private static final Map<ResourceKey<Level>, List<DamageOverTimeEntry>> worldEntries = new HashMap<ResourceKey<Level>, List<DamageOverTimeEntry>>();

    public static void applyDamageOverTime(LivingEntity target, DamageSource damageSource, float totalDamage, int durationTicks) {
        ServerScheduler.INSTANCE.schedule(1, () -> {
            DamageOverTimeEntry entry = new DamageOverTimeEntry(durationTicks, damageSource, target.m_142049_(), totalDamage / ((float)durationTicks / 20.0f));
            worldEntries.computeIfAbsent((ResourceKey<Level>)target.m_20193_().m_46472_(), key -> new ArrayList()).add(entry);
        });
    }

    public static void invalidateAll(LivingEntity target) {
        DamageOverTimeHelper.getDotEntries((Entity)target).forEach(DamageOverTimeEntry::invalidate);
    }

    public static List<DamageOverTimeEntry> getDotEntries(Entity entity) {
        Level entityWorld = entity.m_20193_();
        List<DamageOverTimeEntry> allEntries = worldEntries.get(entityWorld.m_46472_());
        LinkedList<DamageOverTimeEntry> entries = new LinkedList<DamageOverTimeEntry>();
        if (allEntries == null) {
            return entries;
        }
        for (DamageOverTimeEntry entry : allEntries) {
            if (entry.entityId != entity.m_142049_()) continue;
            entries.add(entry);
        }
        return entries;
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Level world = event.world;
        if (world.m_5776_()) {
            return;
        }
        List entries = worldEntries.computeIfAbsent((ResourceKey<Level>)world.m_46472_(), key -> new ArrayList());
        ActiveFlags.IS_DOT_ATTACKING.runIfNotSet(() -> entries.forEach(entry -> {
            if (entry.valid && entry.ticks % 20 == 0) {
                Entity e = world.m_6815_(entry.entityId);
                if (e instanceof LivingEntity && e.m_6084_()) {
                    DamageUtil.shotgunAttack(e, entity -> entity.m_6469_(entry.source, entry.damagePerSecond));
                } else {
                    entry.invalidate();
                }
            }
        }));
        entries.forEach(DamageOverTimeEntry::decrement);
        entries.removeIf(entry -> !entry.valid);
    }

    private static class DamageOverTimeEntry {
        private int ticks;
        private final DamageSource source;
        private final int entityId;
        private final float damagePerSecond;
        private boolean valid = true;

        public DamageOverTimeEntry(int ticks, DamageSource source, int entityId, float damagePerSecond) {
            this.ticks = ticks;
            this.source = source;
            this.entityId = entityId;
            this.damagePerSecond = damagePerSecond;
        }

        private void decrement() {
            --this.ticks;
            this.valid = this.valid && this.ticks > 0;
        }

        private void invalidate() {
            this.valid = false;
        }
    }
}

