/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.calc;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.ItemUnidentifiedArtifact;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.network.message.PlayerStatisticsMessage;
import iskallia.vault.world.data.PlayerFavourData;
import iskallia.vault.world.data.PlayerStatsData;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.logic.objective.raid.RaidChallengeObjective;
import iskallia.vault.world.vault.player.VaultPlayer;
import iskallia.vault.world.vault.player.VaultRunner;
import iskallia.vault.world.vault.player.VaultSpectator;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber
public class PlayerStatisticsCollector {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !(event.player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)event.player;
        if (sPlayer.f_19797_ % 20 != 0) {
            return;
        }
        PlayerFavourData favourData = PlayerFavourData.get(sPlayer.m_183503_());
        UUID playerUUID = sPlayer.m_142081_();
        CompoundTag favourStats = new CompoundTag();
        for (PlayerFavourData.VaultGodType type : PlayerFavourData.VaultGodType.values()) {
            favourStats.m_128365_(type.name(), (Tag)IntTag.m_128679_((int)favourData.getFavour(playerUUID, type)));
        }
        CompoundTag serialized = new CompoundTag();
        serialized.m_128365_("favourStats", (Tag)favourStats);
        PlayerStatisticsMessage pkt = new PlayerStatisticsMessage(serialized);
        ModNetwork.CHANNEL.sendTo((Object)pkt, sPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static class AttributeSnapshot {
        private final String unlocAttributeName;
        private final String parentAttributeName;
        private final double value;
        private final boolean isPercentage;
        private double limit = -1.0;

        public AttributeSnapshot(String unlocAttributeName, double value, boolean isPercentage) {
            this(unlocAttributeName, null, value, isPercentage);
        }

        public AttributeSnapshot(String unlocAttributeName, String parentAttributeName, double value, boolean isPercentage) {
            this.unlocAttributeName = unlocAttributeName;
            this.parentAttributeName = parentAttributeName;
            this.value = value;
            this.isPercentage = isPercentage;
        }

        private AttributeSnapshot setLimit(double limit) {
            this.limit = limit;
            return this;
        }

        public String getAttributeName() {
            return this.unlocAttributeName;
        }

        public String getParentAttributeName() {
            return this.parentAttributeName != null ? this.parentAttributeName : this.getAttributeName();
        }

        public double getValue() {
            return this.value;
        }

        public boolean isPercentage() {
            return this.isPercentage;
        }

        public boolean hasLimit() {
            return this.limit != -1.0;
        }

        public double getLimit() {
            return this.limit;
        }

        public boolean hasHitLimit() {
            return this.hasLimit() && this.getValue() > this.getLimit();
        }

        public CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("key", this.getAttributeName());
            nbt.m_128359_("parent", this.getParentAttributeName());
            nbt.m_128347_("value", this.getValue());
            nbt.m_128379_("isPercentage", this.isPercentage());
            nbt.m_128347_("limit", this.getLimit());
            return nbt;
        }

        public static AttributeSnapshot deserialize(CompoundTag nbt) {
            return new AttributeSnapshot(nbt.m_128461_("key"), nbt.m_128461_("parent"), nbt.m_128459_("value"), nbt.m_128471_("isPercentage")).setLimit(nbt.m_128459_("limit"));
        }
    }

    public static class VaultRunsSnapshot {
        public int vaultRuns;
        public int deaths;
        public int bails;
        public int bossKills;
        public int artifacts;
        public int raidsCompleted;

        public static VaultRunsSnapshot ofPlayer(ServerPlayer sPlayer) {
            PlayerStatsData.Stats vaultPlayerStats = PlayerStatsData.get().get((Player)sPlayer);
            VaultRunsSnapshot snapshot = new VaultRunsSnapshot();
            snapshot.vaultRuns = vaultPlayerStats.getVaults().size();
            block0: for (VaultRaid recordedRaid : vaultPlayerStats.getVaults()) {
                boolean completedAll = true;
                for (VaultObjective objective : recordedRaid.getAllObjectives()) {
                    for (VaultObjective.Crate crate : objective.getCrates()) {
                        for (ItemStack stack : crate.getContents()) {
                            if (!(stack.m_41720_() instanceof ItemUnidentifiedArtifact)) continue;
                            ++snapshot.artifacts;
                        }
                    }
                    if (objective instanceof RaidChallengeObjective) {
                        snapshot.raidsCompleted += ((RaidChallengeObjective)objective).getCompletedRaids();
                    }
                    if (objective.isCompleted()) continue;
                    completedAll = false;
                    break;
                }
                if (completedAll) {
                    ++snapshot.bossKills;
                    continue;
                }
                CrystalData data = recordedRaid.getProperties().getBaseOrDefault(VaultRaid.CRYSTAL_DATA, CrystalData.EMPTY);
                CrystalData.Type vaultType = data.getType();
                if (vaultType != CrystalData.Type.COOP) {
                    for (VaultPlayer vPlayer : recordedRaid.getPlayers()) {
                        if (!vPlayer.hasExited()) continue;
                        if (vPlayer instanceof VaultSpectator) {
                            ++snapshot.deaths;
                            continue block0;
                        }
                        ++snapshot.bails;
                        continue block0;
                    }
                    continue;
                }
                boolean done = true;
                boolean areAllSpectators = true;
                for (VaultPlayer vPlayer : recordedRaid.getPlayers()) {
                    if (!vPlayer.hasExited()) {
                        done = false;
                    }
                    if (!(vPlayer instanceof VaultRunner)) continue;
                    areAllSpectators = false;
                }
                if (!done) continue;
                if (areAllSpectators) {
                    ++snapshot.bails;
                    continue;
                }
                ++snapshot.deaths;
            }
            String uuidStr = sPlayer.m_142081_().toString();
            if (uuidStr.equalsIgnoreCase("d974cbae-e62b-4e34-a1b8-0175a2d41d9a")) {
                snapshot.artifacts += 2;
            }
            if (uuidStr.equalsIgnoreCase("0f5e0db0-13a0-4125-a97a-e9f8e872d521")) {
                snapshot.artifacts += 2;
            }
            if (uuidStr.equalsIgnoreCase("5f820c39-5883-4392-b174-3125ac05e38c")) {
                ++snapshot.artifacts;
            }
            if (uuidStr.equalsIgnoreCase("7ed3587b-e656-4689-90d6-08e11daaf907")) {
                snapshot.artifacts += 2;
            }
            return snapshot;
        }
    }
}

