/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.calc;

import com.google.common.collect.Sets;
import iskallia.vault.aura.AuraManager;
import iskallia.vault.aura.type.EffectAuraConfig;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.gear.attribute.type.EffectAvoidanceSingleMerger;
import iskallia.vault.init.ModEtchings;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.talent.type.EffectTalent;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class GrantedEffectHelper {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        GrantedEffectHelper.applyEffects((LivingEntity)player, GrantedEffectHelper.getEffectData(player, sPlayer.m_183503_(), (MobEffect effect) -> !GrantedEffectHelper.hasImmunity((LivingEntity)player, effect)));
    }

    public static void applyEffects(LivingEntity entity, Map<MobEffect, Integer> effects) {
        effects.forEach((effect, amplifier) -> {
            if (amplifier >= 0) {
                MobEffectInstance activeEffect = entity.m_21124_(effect);
                MobEffectInstance newEffect = new MobEffectInstance(effect, 339, amplifier.intValue(), false, false, true);
                if (activeEffect == null || activeEffect.m_19564_() < amplifier || activeEffect.m_19557_() <= 259) {
                    entity.m_7292_(newEffect);
                }
            }
        });
    }

    public static GrantedEffects getEffectData(Player player, ServerLevel world) {
        return GrantedEffectHelper.getEffectData(player, world, (MobEffect effect) -> true);
    }

    public static Integer getEffectData(Player player, ServerLevel world, MobEffect effect) {
        GrantedEffects effectData = GrantedEffectHelper.getEffectData(player, world, (MobEffect otherEffect) -> otherEffect == effect);
        return effectData.getOrDefault(effect, -1);
    }

    public static GrantedEffects getEffectData(Player player, ServerLevel world, MobEffect ... effects) {
        HashSet filter = Sets.newHashSet((Object[])effects);
        return GrantedEffectHelper.getEffectData(player, world, filter::contains);
    }

    public static GrantedEffects getEffectData(Player player, ServerLevel world, Predicate<MobEffect> effectFilter) {
        GrantedEffects grantedEffects = new GrantedEffects();
        GrantedEffectHelper.getSnapshotEffectData((LivingEntity)player, effectFilter).forEach((effect, realAmplifier) -> grantedEffects.addAmplifier((MobEffect)effect, realAmplifier + 1));
        AuraManager.getInstance().getAurasAffecting((Entity)player).stream().filter(aura -> aura.getAura() instanceof EffectAuraConfig).map(aura -> (EffectAuraConfig)aura.getAura()).forEach(effectAura -> {
            EffectTalent auraTalent = effectAura.getEffect();
            if (effectFilter.test(auraTalent.getEffect())) {
                grantedEffects.addAmplifier(auraTalent);
            }
        });
        CommonEvents.GRANTED_EFFECT.invoke(grantedEffects, world, player, effectFilter);
        return grantedEffects;
    }

    public static GrantedEffects getSnapshotEffectData(LivingEntity entity) {
        return GrantedEffectHelper.getSnapshotEffectData(entity, effect -> true);
    }

    public static GrantedEffects getSnapshotEffectData(LivingEntity entity, Predicate<MobEffect> effectFilter) {
        GrantedEffects grantedEffects = new GrantedEffects();
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        snapshot.getGrantedPotions().getEffects().forEach((effect, amplifier) -> {
            if (effectFilter.test((MobEffect)effect)) {
                grantedEffects.addAmplifier((MobEffect)effect, (int)amplifier);
            }
        });
        return grantedEffects;
    }

    public static boolean hasImmunity(LivingEntity entity, MobEffect effect) {
        if (!AttributeSnapshotHelper.canHaveSnapshot(entity)) {
            return false;
        }
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        if (snapshot.hasEtching(ModEtchings.DIVINITY) && effect.m_19483_() == MobEffectCategory.HARMFUL) {
            return true;
        }
        return snapshot.getImmunities().contains(effect);
    }

    public static Collection<MobEffect> getImmunities(LivingEntity entity) {
        if (!AttributeSnapshotHelper.canHaveSnapshot(entity)) {
            return Collections.emptyList();
        }
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        HashSet<MobEffect> immunities = new HashSet<MobEffect>(snapshot.getImmunities());
        if (snapshot.hasEtching(ModEtchings.DIVINITY)) {
            ForgeRegistries.MOB_EFFECTS.getValues().stream().filter(e -> e.m_19483_() == MobEffectCategory.HARMFUL).forEach(immunities::add);
        }
        return immunities;
    }

    public static boolean canAvoidEffect(MobEffect effect, LivingEntity entity, Random random) {
        if (!AttributeSnapshotHelper.canHaveSnapshot(entity)) {
            return false;
        }
        if (GrantedEffectHelper.hasImmunity(entity, effect)) {
            return true;
        }
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        float chance = snapshot.getAttributeValue(ModGearAttributes.EFFECT_AVOIDANCE, EffectAvoidanceSingleMerger.of(effect)).floatValue();
        return chance > random.nextFloat();
    }

    public static class GrantedEffects
    extends HashMap<MobEffect, Integer> {
        public void addAmplifier(EffectTalent talent) {
            this.addAmplifier(talent.getEffect(), talent.getAmplifier());
        }

        public void addAmplifier(MobEffect effect, int amplifier) {
            int ampl = this.getOrDefault(effect, -1);
            this.put(effect, ampl + amplifier);
        }
    }
}

