/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.calc;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModEtchings;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.config.spi.AbstractAbilityConfig;
import iskallia.vault.skill.ability.group.AbilityGroup;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.AttributeLimitHelper;
import iskallia.vault.util.calc.PlayerStat;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class CooldownHelper {
    public static int adjustCooldown(ServerPlayer player, AbilityNode<?, ?> abilityNode) {
        Object abilityConfig = abilityNode.getAbilityConfig();
        if (abilityConfig == null) {
            return 0;
        }
        int cooldownTicks = ((AbstractAbilityConfig)abilityConfig).getCooldownTicks();
        AbilityGroup<?, ?> abilityGroup = abilityNode.getGroup();
        return CooldownHelper.adjustCooldown(player, cooldownTicks);
    }

    public static int adjustCooldown(ServerPlayer player, int cooldownTicks) {
        float cooldownMultiplier = CooldownHelper.getCooldownMultiplier(player);
        cooldownTicks -= Mth.m_14143_((float)((float)cooldownTicks * cooldownMultiplier));
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
        if (snapshot.hasEtching(ModEtchings.RIFT)) {
            cooldownTicks = (int)((float)cooldownTicks * ModEtchings.RIFT.getCooldownMultiplier());
        }
        return cooldownTicks;
    }

    public static float getCooldownMultiplier(ServerPlayer player) {
        return Mth.m_14036_((float)CooldownHelper.getCooldownMultiplierUnlimited(player), (float)0.0f, (float)AttributeLimitHelper.getCooldownReductionLimit((LivingEntity)player));
    }

    private static float getCooldownMultiplierUnlimited(ServerPlayer player) {
        float multiplier = 0.0f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
        multiplier += snapshot.getAttributeValue(ModGearAttributes.COOLDOWN_REDUCTION, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        multiplier = CommonEvents.PLAYER_STAT.invoke(PlayerStat.COOLDOWN_REDUCTION, (LivingEntity)player, multiplier).getValue();
        return multiplier;
    }
}

