/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.calc;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.AttributeLimitHelper;
import iskallia.vault.util.calc.PlayerStat;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class BlockChanceHelper {
    public static void setPlayerBlocking(Player player) {
        if (player instanceof PlayerBlockAnimationAccess) {
            ((PlayerBlockAnimationAccess)player).setForceBlocking();
        }
    }

    public static boolean isPlayerBlocking(Player player) {
        if (player instanceof PlayerBlockAnimationAccess) {
            PlayerBlockAnimationAccess blockAccess = (PlayerBlockAnimationAccess)player;
            return blockAccess.isForceBlocking();
        }
        return false;
    }

    public static float getBlockChance(LivingEntity entity) {
        return Mth.m_14036_((float)BlockChanceHelper.getBlockChanceUnlimited(entity), (float)0.0f, (float)AttributeLimitHelper.getBlockChanceLimit(entity));
    }

    public static float getBlockChanceUnlimited(LivingEntity entity) {
        float chance = 0.0f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        chance += snapshot.getAttributeValue(ModGearAttributes.BLOCK, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        chance = CommonEvents.PLAYER_STAT.invoke(PlayerStat.BLOCK_CHANCE, entity, chance).getValue();
        return chance;
    }

    public static interface PlayerBlockAnimationAccess {
        public void setForceBlocking();

        public boolean isForceBlocking();
    }
}

