/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.client.ClientDamageData;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.BlockChanceHelper;
import iskallia.vault.util.calc.ResistanceHelper;
import iskallia.vault.util.damage.PlayerDamageHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class StatUtils {
    public static double getAverageDps(Player player) {
        MobEffectInstance inst;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
        double attackSpeed = player.m_21133_(Attributes.f_22283_);
        double attackDamage = player.m_21133_(Attributes.f_22281_);
        if (player.m_183503_().m_5776_() && (inst = player.m_21124_(MobEffects.f_19600_)) != null) {
            attackDamage += (double)(3 * (inst.m_19564_() + 1));
        }
        float chance = snapshot.getAttributeValue(ModGearAttributes.FATAL_STRIKE_CHANCE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        double damage = attackDamage * (double)snapshot.getAttributeValue(ModGearAttributes.FATAL_STRIKE_DAMAGE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        attackDamage += attackDamage * (double)chance * damage;
        float dmgIncrease = snapshot.getAttributeValue(ModGearAttributes.DAMAGE_INCREASE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        attackDamage *= (double)(1.0f + dmgIncrease);
        float dynamicDmgMultiplier = player instanceof ServerPlayer ? PlayerDamageHelper.getDamageMultiplier(player, true) : ClientDamageData.getCurrentDamageMultiplier();
        return (attackDamage *= (double)dynamicDmgMultiplier) * attackSpeed;
    }

    public static double getDefence(Player player) {
        int armor = player.m_21230_();
        float resistance = ResistanceHelper.getResistance((LivingEntity)player);
        float blockChance = BlockChanceHelper.getBlockChance((LivingEntity)player);
        double dmgReduction = StatUtils.getArmorMultiplier(armor);
        dmgReduction *= (double)(1.0f - resistance);
        return 1.0 - (dmgReduction *= (double)(1.0f - blockChance));
    }

    public static float getArmorMultiplier(float armor) {
        return 1.0f - 1.0f / ((float)Math.pow(40.0f / armor, 2.0) + 1.0f);
    }
}

