/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class SkillStyleConverter {
    public static void main(String[] args) throws IOException {
        SkillStyleConverter.extractSkillStyles(Paths.get(".local/old_configs/abilities_gui_styles.json", new String[0]), Paths.get("src/main/resources/assets/the_vault/textures/gui/abilities.png", new String[0]), Paths.get("src/main/resources/assets/the_vault/textures/gui/abilities", new String[0]));
        SkillStyleConverter.extractSkillStyles(Paths.get(".local/old_configs/researches_gui_styles.json", new String[0]), Paths.get("src/main/resources/assets/the_vault/textures/gui/researches.png", new String[0]), Paths.get("src/main/resources/assets/the_vault/textures/gui/researches", new String[0]));
        SkillStyleConverter.extractSkillStyles(Paths.get(".local/old_configs/talents_gui_styles.json", new String[0]), Paths.get("src/main/resources/assets/the_vault/textures/gui/talents.png", new String[0]), Paths.get("src/main/resources/assets/the_vault/textures/gui/talents", new String[0]));
    }

    private static void extractSkillStyles(Path jsonPath, Path atlasPath, Path outputPath) throws IOException {
        Gson gson = new GsonBuilder().create();
        Styles styles = (Styles)gson.fromJson((Reader)new FileReader(jsonPath.toFile()), Styles.class);
        BufferedImage bufferedImage = SkillStyleConverter.loadImage(atlasPath);
        for (Map.Entry<String, SkillStyle> entry : styles.styles.entrySet()) {
            String name = entry.getKey();
            SkillStyle style = entry.getValue();
            BufferedImage imageSlice = SkillStyleConverter.getImageSlice(bufferedImage, 16, 16, style.u / 16, style.v / 16);
            Path targetImagePath = outputPath.resolve(name.toLowerCase().replace(" ", "_") + ".png");
            SkillStyleConverter.writeImage(imageSlice, targetImagePath);
            System.out.println(targetImagePath);
        }
    }

    public static BufferedImage loadImage(Path imagePath) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = Files.newInputStream(imagePath, new OpenOption[0]);
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeImage(BufferedImage sourceImage, Path targetImagePath) throws IOException {
        Path parent = targetImagePath.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        ImageIO.write((RenderedImage)sourceImage, "png", targetImagePath.toFile());
    }

    public static BufferedImage getImageSlice(BufferedImage sourceImage, int sliceWidth, int sliceHeight, int x, int y) {
        BufferedImage imageSlice = new BufferedImage(sliceWidth, sliceHeight, sourceImage.getType());
        Graphics2D gr = imageSlice.createGraphics();
        gr.drawImage(sourceImage, 0, 0, sliceWidth, sliceHeight, sliceWidth * x, sliceHeight * y, sliceWidth * x + sliceWidth, sliceHeight * y + sliceHeight, null);
        gr.dispose();
        return imageSlice;
    }

    public static class Styles {
        @Expose
        public HashMap<String, SkillStyle> styles;
    }

    public static class SkillStyle {
        @Expose
        public int u;
        @Expose
        public int v;

        public String toString() {
            return "SkillStyle{u=" + this.u + ", v=" + this.v + "}";
        }
    }
}

