/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModSounds;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.util.calc.LeechHelper;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerLeechHelper {
    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (attacker.m_20193_().m_5776_()) {
            return;
        }
        float leechMultiplier = 1.0f;
        if (ActiveFlags.IS_AOE_ATTACKING.isSet() || ActiveFlags.IS_DOT_ATTACKING.isSet() || ActiveFlags.IS_REFLECT_ATTACKING.isSet()) {
            return;
        }
        float leech = LeechHelper.getLeechPercent(attacker);
        if ((double)(leech *= leechMultiplier) > 1.0E-4) {
            PlayerLeechHelper.leechHealth(attacker, event.getAmount() * leech);
        }
    }

    private static void leechHealth(LivingEntity attacker, float amountLeeched) {
        ActiveFlags.IS_LEECHING.runIfNotSet(() -> attacker.m_5634_(amountLeeched));
        if ((double)attacker.m_21187_().nextFloat() <= 0.2) {
            float pitch = MathUtilities.randomFloat(1.0f, 1.5f);
            attacker.m_20193_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), ModSounds.VAMPIRE_HISSING_SFX, SoundSource.MASTER, 0.020000001f, pitch);
        }
    }
}

