/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.registries.ForgeRegistries;

public class OverlevelEnchantHelper {
    public static int getOverlevels(ItemStack enchantedBookStack) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)enchantedBookStack);
        for (Enchantment enchantment : enchantments.keySet()) {
            int level = (Integer)enchantments.get(enchantment);
            if (level <= enchantment.m_6586_()) continue;
            return level - enchantment.m_6586_();
        }
        return -1;
    }

    public static Map<Enchantment, Integer> getEnchantments(ItemStack stack) {
        CompoundTag nbt = Optional.ofNullable(stack.m_41783_()).orElseGet(CompoundTag::new);
        ListTag enchantmentsNBT = nbt.m_128437_(stack.m_41720_() == Items.f_42690_ ? "StoredEnchantments" : "Enchantments", 10);
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        for (int i = 0; i < enchantmentsNBT.size(); ++i) {
            CompoundTag enchantmentNBT = enchantmentsNBT.m_128728_(i);
            ResourceLocation id = new ResourceLocation(enchantmentNBT.m_128461_("id"));
            int level = enchantmentNBT.m_128451_("lvl");
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id);
            if (enchantment == null) continue;
            enchantments.put(enchantment, level);
        }
        return enchantments;
    }

    public static ItemStack increaseFortuneBy(ItemStack itemStack, int amount) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        int level = enchantments.getOrDefault(Enchantments.f_44987_, 0);
        enchantments.put(Enchantments.f_44987_, level + amount);
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)itemStack);
        return itemStack;
    }

    public static ItemStack increaseUnbreakingBy(ItemStack itemStack, int amount) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        int level = enchantments.getOrDefault(Enchantments.f_44986_, 0);
        enchantments.put(Enchantments.f_44986_, level + amount);
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)itemStack);
        return itemStack;
    }
}

