/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.vault.client.ClientTalentData;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.vault.ClientVaults;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.skill.talent.Talent;
import iskallia.vault.skill.talent.TalentGroup;
import iskallia.vault.skill.talent.TalentNode;
import iskallia.vault.skill.talent.TalentTree;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.data.PlayerTalentsData;
import iskallia.vault.world.data.ServerVaults;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MiscUtils {
    private static final Random rand = new Random();

    public static <T> T eitherOf(Random r, T ... selection) {
        if (selection.length == 0) {
            return null;
        }
        return selection[r.nextInt(selection.length)];
    }

    public static <T> List<T> concat(List<T> list1, T ... elements) {
        return Stream.concat(list1.stream(), Arrays.stream(elements)).collect(Collectors.toList());
    }

    public static <T> List<T> concat(List<T> list1, List<T> list2) {
        return Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList());
    }

    public static Point2D.Float getMidpoint(Rectangle r) {
        return new Point2D.Float((float)r.x + (float)r.width / 2.0f, (float)r.y + (float)r.height / 2.0f);
    }

    public static <T extends Talent> Optional<TalentNode<T>> getTalent(Player player, TalentGroup<T> talentGroup) {
        if (player instanceof ServerPlayer) {
            TalentTree talents = PlayerTalentsData.get(((ServerPlayer)player).m_183503_()).getTalents(player);
            TalentNode<T> node = talents.getNodeOf(talentGroup);
            if (node.isLearned()) {
                return Optional.of(node);
            }
            return Optional.empty();
        }
        return Optional.ofNullable(ClientTalentData.getLearnedTalentNode(talentGroup));
    }

    public static boolean hasEmptySlot(Container inventory) {
        return MiscUtils.getRandomEmptySlot(inventory) != -1;
    }

    public static boolean hasEmptySlot(IItemHandler inventory) {
        return MiscUtils.getRandomEmptySlot(inventory) != -1;
    }

    public static int getRandomEmptySlot(Container inventory) {
        return MiscUtils.getRandomEmptySlot((IItemHandler)new InvWrapper(inventory));
    }

    public static int getRandomEmptySlot(IItemHandler handler) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            if (!handler.getStackInSlot(slot).m_41619_()) continue;
            slots.add(slot);
        }
        if (slots.isEmpty()) {
            return -1;
        }
        return (Integer)MiscUtils.getRandomEntry(slots, rand);
    }

    public static int getRandomSlot(IItemHandler handler) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            slots.add(slot);
        }
        if (slots.isEmpty()) {
            return -1;
        }
        return (Integer)MiscUtils.getRandomEntry(slots, rand);
    }

    public static List<Integer> getEmptySlots(Container inventory) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!inventory.m_8020_(i).m_41619_()) continue;
            list.add(i);
        }
        return list;
    }

    public static boolean inventoryContains(Container inventory, Predicate<ItemStack> filter) {
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            if (!filter.test(inventory.m_8020_(slot))) continue;
            return true;
        }
        return false;
    }

    public static boolean inventoryContains(IItemHandler handler, Predicate<ItemStack> filter) {
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            if (!filter.test(handler.getStackInSlot(slot))) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> mergeItemStacks(List<ItemStack> stacks) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        block0: for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            for (ItemStack existing : out) {
                if (!MiscUtils.canMerge(existing, stack)) continue;
                existing.m_41764_(existing.m_41613_() + stack.m_41613_());
                continue block0;
            }
            out.add(stack);
        }
        return out;
    }

    public static List<ItemStack> splitAndLimitStackSize(List<ItemStack> stacks) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            int newCount;
            if (stack.m_41619_()) continue;
            for (int i = stack.m_41613_(); i > 0; i -= newCount) {
                newCount = Math.min(i, stack.m_41741_());
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(newCount);
                out.add(copy);
            }
        }
        return out;
    }

    public static boolean canMerge(ItemStack stack, ItemStack other) {
        return stack.m_41720_() == other.m_41720_() && ItemStack.m_41658_((ItemStack)stack, (ItemStack)other);
    }

    public static boolean canFullyMergeIntoSlot(Container inventory, int slot, ItemStack stack) {
        if (stack.m_41619_()) {
            return true;
        }
        ItemStack existing = inventory.m_8020_(slot);
        if (existing.m_41619_()) {
            return inventory.m_6893_() >= stack.m_41613_();
        }
        if (!MiscUtils.canMerge(existing, stack)) {
            return false;
        }
        return inventory.m_6893_() >= existing.m_41613_() + stack.m_41613_();
    }

    public static boolean mergeIntoInventory(Container inventory, ItemStack toAdd) {
        if (toAdd.m_41619_()) {
            return true;
        }
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            int maxToAdd;
            ItemStack stack = inventory.m_8020_(slot);
            if (stack.m_41619_()) continue;
            if (MiscUtils.canMerge(stack, toAdd) && (maxToAdd = Math.min(Math.min(stack.m_41741_(), inventory.m_6893_()) - stack.m_41613_(), toAdd.m_41613_())) > 0) {
                toAdd.m_41774_(maxToAdd);
                stack.m_41769_(maxToAdd);
            }
            if (!toAdd.m_41619_()) continue;
            return true;
        }
        int maxStackSize = Math.min(toAdd.m_41741_(), inventory.m_6893_());
        List<Integer> emptySlots = MiscUtils.getEmptySlots(inventory);
        for (int emptySlotId : emptySlots) {
            inventory.m_6836_(emptySlotId, toAdd.m_41620_(maxStackSize));
            if (!toAdd.m_41619_()) continue;
            return true;
        }
        return false;
    }

    public static boolean canMergeIntoInventory(Container inventory, ItemStack toAdd) {
        if (toAdd.m_41619_()) {
            return true;
        }
        int toMerge = toAdd.m_41613_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            int maxToAdd;
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !MiscUtils.canMerge(stack, toAdd) || (maxToAdd = Math.min(stack.m_41741_() - stack.m_41613_(), toMerge)) <= 0) continue;
            toMerge -= maxToAdd;
        }
        if (toMerge <= 0) {
            return true;
        }
        int maxStackSize = Math.min(toAdd.m_41741_(), inventory.m_6893_());
        return MiscUtils.getEmptySlots(inventory).size() * maxStackSize >= toMerge;
    }

    public static void addStackToSlot(Container inventory, int slot, ItemStack toAdd) {
        if (toAdd.m_41619_()) {
            return;
        }
        ItemStack stack = inventory.m_8020_(slot);
        if (stack.m_41619_()) {
            inventory.m_6836_(slot, toAdd.m_41777_());
            return;
        }
        if (MiscUtils.canMerge(stack, toAdd)) {
            stack.m_41769_(toAdd.m_41613_());
        }
    }

    public static boolean addItemStack(Container inventory, ItemStack stack) {
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            ItemStack contained = inventory.m_8020_(slot);
            if (!contained.m_41619_()) continue;
            inventory.m_6836_(slot, stack);
            return true;
        }
        return false;
    }

    public static <T extends Enum<T>> T getEnumEntry(Class<T> enumClass, int index) {
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        return (T)constants[Mth.m_14045_((int)index, (int)0, (int)(constants.length - 1))];
    }

    public static Optional<BlockPos> getEmptyNearby(LevelReader world, BlockPos pos) {
        return BlockPos.m_121930_((BlockPos)pos, (int)8, (int)8, arg_0 -> ((LevelReader)world).m_46859_(arg_0));
    }

    public static BlockPos getRandomPos(BoundingBox box, Random r) {
        return MiscUtils.getRandomPos(AABB.m_82321_((BoundingBox)box), r);
    }

    public static BlockPos getRandomPos(AABB box, Random r) {
        int sizeX = Math.max(1, Mth.m_14107_((double)box.m_82362_()));
        int sizeY = Math.max(1, Mth.m_14107_((double)box.m_82376_()));
        int sizeZ = Math.max(1, Mth.m_14107_((double)box.m_82385_()));
        return new BlockPos(box.f_82288_ + (double)r.nextInt(sizeX), box.f_82289_ + (double)r.nextInt(sizeY), box.f_82290_ + (double)r.nextInt(sizeZ));
    }

    public static Vec3 getRandomOffset(AABB box, Random r) {
        return new Vec3(box.f_82288_ + (double)r.nextFloat() * (box.f_82291_ - box.f_82288_), box.f_82289_ + (double)r.nextFloat() * (box.f_82292_ - box.f_82289_), box.f_82290_ + (double)r.nextFloat() * (box.f_82293_ - box.f_82290_));
    }

    public static Vec3 getRandomOffset(BlockPos pos, Random r) {
        return new Vec3((double)((float)pos.m_123341_() + r.nextFloat()), (double)((float)pos.m_123342_() + r.nextFloat()), (double)((float)pos.m_123343_() + r.nextFloat()));
    }

    public static Vec3 getRandomOffset(BlockPos pos, Random r, float scale) {
        float x = (float)pos.m_123341_() + 0.5f - scale / 2.0f + r.nextFloat() * scale;
        float y = (float)pos.m_123342_() + 0.5f - scale / 2.0f + r.nextFloat() * scale;
        float z = (float)pos.m_123343_() + 0.5f - scale / 2.0f + r.nextFloat() * scale;
        return new Vec3((double)x, (double)y, (double)z);
    }

    public static Collection<ChunkPos> getChunksContaining(AABB box) {
        return MiscUtils.getChunksContaining(new Vec3i(box.f_82288_, box.f_82289_, box.f_82290_), new Vec3i(box.f_82291_, box.f_82292_, box.f_82293_));
    }

    public static Collection<ChunkPos> getChunksContaining(Vec3i min, Vec3i max) {
        ArrayList affected = Lists.newArrayList();
        int maxX = max.m_123341_() >> 4;
        int maxZ = max.m_123343_() >> 4;
        for (int chX = min.m_123341_() >> 4; chX <= maxX; ++chX) {
            for (int chZ = min.m_123343_() >> 4; chZ <= maxZ; ++chZ) {
                affected.add(new ChunkPos(chX, chZ));
            }
        }
        return affected;
    }

    @Nullable
    public static <T> T getRandomEntry(T ... entries) {
        return MiscUtils.getRandomEntry(Lists.newArrayList((Object[])entries), rand);
    }

    @Nullable
    public static <T> T getRandomEntry(Collection<T> collection) {
        return MiscUtils.getRandomEntry(collection, rand);
    }

    @Nullable
    public static <T> T getRandomEntry(Collection<T> collection, Random rand) {
        if (collection.isEmpty()) {
            return null;
        }
        int randomPick = rand.nextInt(collection.size());
        return (T)Iterables.get(collection, (int)randomPick, null);
    }

    public static void broadcast(Component message) {
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        if (srv != null) {
            srv.m_6846_().m_11264_(message, ChatType.CHAT, Util.f_137441_);
        }
    }

    @Nullable
    public static Player findPlayerUsingAnvil(ItemStack left, ItemStack right) {
        for (Player player : SidedHelper.getSidedPlayers()) {
            NonNullList contents;
            if (!(player.f_36096_ instanceof AnvilMenu) || (contents = player.f_36096_.m_38927_()).get(0) != left || contents.get(1) != right) continue;
            return player;
        }
        return null;
    }

    public static Optional<Vault> getVault(Player player) {
        if (!ServerVaults.isInVault((Entity)player)) {
            return Optional.empty();
        }
        if (player.m_183503_().m_5776_()) {
            return Optional.ofNullable(ClientVaults.ACTIVE);
        }
        return ServerVaults.get(player.m_183503_());
    }

    public static <T> Optional<T> getVaultData(Player player, FieldKey<T> key) {
        return MiscUtils.getVault(player).filter(vault -> vault.has(key)).map(vault -> vault.get(key));
    }

    public static void fillContainer(AbstractContainerMenu ct, NonNullList<ItemStack> items) {
        for (int slot = 0; slot < items.size(); ++slot) {
            ct.m_182406_(slot, ct.m_182424_(), (ItemStack)items.get(slot));
        }
    }

    public static void clearPlayerInventory(Player player) {
        player.m_150109_().m_6211_();
        IntegrationCurios.clearCurios((LivingEntity)player);
    }

    public static void giveItem(ServerPlayer player, ItemStack stack) {
        stack = stack.m_41777_();
        if (player.m_150109_().m_36054_(stack) && stack.m_41619_()) {
            stack.m_41764_(1);
            ItemEntity dropped = player.m_36176_(stack, false);
            if (dropped != null) {
                dropped.m_32065_();
            }
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_21187_().nextFloat() - player.m_21187_().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.f_36095_.m_38946_();
        } else {
            ItemEntity dropped = player.m_36176_(stack, false);
            if (dropped != null) {
                dropped.m_32061_();
                dropped.m_32047_(player.m_142081_());
            }
        }
    }

    public static Vector3f getRandomCirclePosition(Vector3f centerOffset, Vector3f axis, float radius) {
        return MiscUtils.getCirclePosition(centerOffset, axis, radius, (float)(Math.random() * 360.0));
    }

    public static Vector3f getCirclePosition(Vector3f centerOffset, Vector3f axis, float radius, float degree) {
        Vector3f circleVec = MiscUtils.normalize(MiscUtils.perpendicular(axis));
        circleVec = new Vector3f(circleVec.m_122239_() * radius, circleVec.m_122260_() * radius, circleVec.m_122269_() * radius);
        Quaternion rotQuat = new Quaternion(axis, degree, true);
        circleVec.m_122251_(rotQuat);
        return new Vector3f(circleVec.m_122239_() + centerOffset.m_122239_(), circleVec.m_122260_() + centerOffset.m_122260_(), circleVec.m_122269_() + centerOffset.m_122269_());
    }

    public static Vector3f normalize(Vector3f vec) {
        float lengthSq = vec.m_122239_() * vec.m_122239_() + vec.m_122260_() * vec.m_122260_() + vec.m_122269_() * vec.m_122269_();
        float length = (float)Math.sqrt(lengthSq);
        return new Vector3f(vec.m_122239_() / length, vec.m_122260_() / length, vec.m_122269_() / length);
    }

    public static Vector3f perpendicular(Vector3f vec) {
        if ((double)vec.m_122269_() == 0.0) {
            return new Vector3f(vec.m_122260_(), -vec.m_122239_(), 0.0f);
        }
        return new Vector3f(0.0f, vec.m_122269_(), -vec.m_122260_());
    }

    public static boolean isPlayerFakeMP(ServerPlayer player) {
        if (player instanceof FakePlayer) {
            return true;
        }
        try {
            player.m_9239_().length();
            player.f_8906_.f_9742_.m_129523_().toString();
            if (!player.f_8906_.f_9742_.channel().isOpen()) {
                return true;
            }
        }
        catch (Exception exc) {
            return true;
        }
        return false;
    }

    public static List<TextComponent> splitDescriptionText(String text) {
        ArrayList<TextComponent> tooltip = new ArrayList<TextComponent>();
        StringBuilder sb = new StringBuilder();
        for (String word : text.split("\\s+")) {
            sb.append(word).append(" ");
            if (sb.length() < 30) continue;
            tooltip.add(new TextComponent(sb.toString().trim()));
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            tooltip.add(new TextComponent(sb.toString().trim()));
        }
        return tooltip;
    }

    public static <T> Class<T> cast(Class<?> cls) {
        return cls;
    }
}

