/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class MathUtilities {
    private static final Random rand = new Random();

    public static float randomFloat(float min, float max) {
        if (min >= max) {
            return min;
        }
        return min + rand.nextFloat() * (max - min);
    }

    public static int getRandomInt(int min, int max) {
        if (min >= max) {
            return min;
        }
        return min + rand.nextInt(max - min);
    }

    public static double map(double value, double x0, double y0, double x1, double y1) {
        return x1 + (y1 - x1) * ((value - x0) / (y0 - x0));
    }

    public static double length(Vec2 vec) {
        return Math.sqrt(vec.f_82470_ * vec.f_82470_ + vec.f_82471_ * vec.f_82471_);
    }

    public static double extractYaw(Vec3 vec) {
        return Math.atan2(vec.m_7094_(), vec.m_7096_());
    }

    public static double extractPitch(Vec3 vec) {
        return Math.asin(vec.m_7098_() / vec.m_82553_());
    }

    public static Vec3 rotatePitch(Vec3 vec, float pitch) {
        float f = Mth.m_14089_((float)pitch);
        float f1 = Mth.m_14031_((float)pitch);
        double d0 = vec.m_7096_();
        double d1 = vec.m_7098_() * (double)f + vec.m_7094_() * (double)f1;
        double d2 = vec.m_7094_() * (double)f - vec.m_7098_() * (double)f1;
        return new Vec3(d0, d1, d2);
    }

    public static Vec3 rotateYaw(Vec3 vec, float yaw) {
        float f = Mth.m_14089_((float)yaw);
        float f1 = Mth.m_14031_((float)yaw);
        double d0 = vec.m_7096_() * (double)f + vec.m_7094_() * (double)f1;
        double d1 = vec.m_7098_();
        double d2 = vec.m_7094_() * (double)f - vec.m_7096_() * (double)f1;
        return new Vec3(d0, d1, d2);
    }

    public static Vec3 rotateRoll(Vec3 vec, float roll) {
        float f = Mth.m_14089_((float)roll);
        float f1 = Mth.m_14031_((float)roll);
        double d0 = vec.m_7096_() * (double)f + vec.m_7098_() * (double)f1;
        double d1 = vec.m_7098_() * (double)f - vec.m_7096_() * (double)f1;
        double d2 = vec.m_7094_();
        return new Vec3(d0, d1, d2);
    }
}

