/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import iskallia.vault.VaultMod;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.apache.logging.log4j.Logger;

public class CodecUtils {
    public static <T> Optional<T> readJson(Codec<T> codec, JsonElement jsonElement) {
        return codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).resultOrPartial(arg_0 -> ((Logger)VaultMod.LOGGER).error(arg_0));
    }

    public static <T> void writeJson(Codec<T> codec, T value, Consumer<JsonElement> successConsumer) {
        codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).resultOrPartial(arg_0 -> ((Logger)VaultMod.LOGGER).error(arg_0)).ifPresent(successConsumer);
    }

    public static <T> JsonElement writeJson(Codec<T> codec, T value) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow(false, arg_0 -> ((Logger)VaultMod.LOGGER).error(arg_0));
    }

    public static <T> T readNBT(Codec<T> codec, CompoundTag tag, String targetKey, T defaultValue) {
        return CodecUtils.readNBT(codec, tag.m_128423_(targetKey)).orElse(defaultValue);
    }

    public static <T> T readNBT(Codec<T> codec, Tag nbt, T defaultValue) {
        return CodecUtils.readNBT(codec, nbt).orElse(defaultValue);
    }

    public static <T> Optional<T> readNBT(Codec<T> codec, Tag nbt) {
        return codec.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt).resultOrPartial(arg_0 -> ((Logger)VaultMod.LOGGER).error(arg_0));
    }

    public static <T> void writeNBT(Codec<T> codec, T value, CompoundTag targetTag, String targetKey) {
        CodecUtils.writeNBT(codec, value, nbt -> targetTag.m_128365_(targetKey, nbt));
    }

    public static <T> void writeNBT(Codec<T> codec, T value, Consumer<Tag> successConsumer) {
        codec.encodeStart((DynamicOps)NbtOps.f_128958_, value).resultOrPartial(arg_0 -> ((Logger)VaultMod.LOGGER).error(arg_0)).ifPresent(successConsumer);
    }

    public static <T> Tag writeNBT(Codec<T> codec, T value) {
        return (Tag)codec.encodeStart((DynamicOps)NbtOps.f_128958_, value).getOrThrow(false, arg_0 -> ((Logger)VaultMod.LOGGER).error(arg_0));
    }
}

