/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.snapshot;

import iskallia.vault.etching.EtchingSet;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.type.EffectAttributeMerger;
import iskallia.vault.gear.attribute.type.VaultGearAttributeType;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.common.extensions.IForgeFriendlyByteBuf;

public class AttributeSnapshot {
    public static final AttributeSnapshot EMPTY = new AttributeSnapshot();
    Map<VaultGearAttribute<?>, AttributeValue<?, ?>> gearAttributeValues = new HashMap();
    List<EtchingSet<?>> etchings = new ArrayList();

    protected AttributeSnapshot() {
    }

    public AttributeSnapshot(FriendlyByteBuf buf) {
        this.read(buf);
    }

    public <T, V> V getAttributeValue(VaultGearAttribute<T> attribute, VaultGearAttributeTypeMerger<T, V> merger) {
        AttributeValue<?, ?> attributeCache = this.gearAttributeValues.get(attribute);
        V merged = merger.getBaseValue();
        if (attributeCache == null) {
            return merged;
        }
        for (Object value : attributeCache.cachedValues) {
            merged = merger.merge(merged, value);
        }
        return merged;
    }

    public Set<MobEffect> getImmunities() {
        return this.getAttributeValue(ModGearAttributes.EFFECT_IMMUNITY, VaultGearAttributeTypeMerger.asSet());
    }

    public EffectAttributeMerger.CombinedEffects getGrantedPotions() {
        return this.getAttributeValue(ModGearAttributes.EFFECT, EffectAttributeMerger.getInstance());
    }

    public List<EtchingSet<?>> getEtchings() {
        return Collections.unmodifiableList(this.etchings);
    }

    public boolean hasEtching(EtchingSet<?> set) {
        return this.getEtchings().contains(set);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.gearAttributeValues.size());
        this.gearAttributeValues.forEach((attribute, value) -> {
            buf.m_130085_(attribute.getRegistryName());
            value.write(buf, (VaultGearAttribute<?>)((Object)attribute));
        });
        buf.m_178352_(this.etchings, IForgeFriendlyByteBuf::writeRegistryId);
    }

    protected void read(FriendlyByteBuf buf) {
        int attrCacheSize = buf.readInt();
        for (int i = 0; i < attrCacheSize; ++i) {
            VaultGearAttribute<?> attribute = VaultGearAttributeRegistry.getAttribute(buf.m_130281_());
            AttributeValue value = new AttributeValue(buf, attribute);
            this.gearAttributeValues.put(attribute, value);
        }
        this.etchings = buf.m_178366_(IForgeFriendlyByteBuf::readRegistryId);
    }

    public static class AttributeValue<T, V> {
        private final List<T> cachedValues = new ArrayList<T>();

        AttributeValue() {
        }

        private AttributeValue(FriendlyByteBuf buf, VaultGearAttribute<T> attribute) {
            this.read(buf, attribute);
        }

        void addCachedValue(Object object) {
            this.cachedValues.add(object);
        }

        void addCachedValues(List<?> objects) {
            objects.forEach(this::addCachedValue);
        }

        private void write(FriendlyByteBuf buf, VaultGearAttribute<?> attribute) {
            VaultGearAttributeType<?> type = attribute.getType();
            buf.m_178352_(this.cachedValues, type::netWrite);
        }

        private void read(FriendlyByteBuf buf, VaultGearAttribute<T> attribute) {
            VaultGearAttributeType<T> type = attribute.getType();
            this.cachedValues.addAll(buf.m_178366_(type::netRead));
        }
    }
}

