/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.talent.GearAttributeTalent;
import iskallia.vault.skill.talent.type.PlayerTalent;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class VanillaAttributeTalent
extends PlayerTalent
implements GearAttributeTalent {
    @Expose
    private final String attribute;
    @Expose
    private final Modifier modifier;

    public VanillaAttributeTalent(int cost, Attribute attribute, Modifier modifier) {
        this(cost, Registry.f_122866_.m_7981_((Object)attribute).toString(), modifier);
    }

    public VanillaAttributeTalent(int cost, String attribute, Modifier modifier) {
        super(cost);
        this.attribute = attribute;
        this.modifier = modifier;
    }

    public Attribute getAttribute() {
        return (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(this.attribute));
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    @Override
    public void onAdded(Player player) {
        this.onRemoved(player);
        this.runIfPresent(player, attributeData -> attributeData.m_22118_(this.getModifier().toMCModifier()));
    }

    @Override
    public void tick(ServerPlayer player) {
        this.runIfPresent((Player)player, attributeData -> {
            if (!attributeData.m_22109_(this.getModifier().toMCModifier())) {
                this.onAdded((Player)player);
            }
        });
    }

    @Override
    public void onRemoved(Player player) {
        this.runIfPresent(player, attributeData -> attributeData.m_22120_(UUID.fromString(this.getModifier().id)));
    }

    public boolean runIfPresent(Player player, Consumer<AttributeInstance> action) {
        AttributeInstance instance = player.m_21051_(this.getAttribute());
        if (instance == null) {
            return false;
        }
        action.accept(instance);
        return true;
    }

    @Override
    public List<VaultGearAttributeInstance<?>> getAttributes() {
        Attribute attr = this.getAttribute();
        VaultGearAttribute<?> gearAttribute = ModGearAttributes.getGearAttribute(attr, this.getModifier().getOperation());
        if (gearAttribute == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new VaultGearAttributeInstance[]{VaultGearAttributeInstance.cast(gearAttribute, this.getModifier().amount)});
    }

    public static class Modifier {
        @Expose
        public final String id;
        @Expose
        public final String name;
        @Expose
        public final double amount;
        @Expose
        public final int operation;

        public Modifier(String name, double amount, AttributeModifier.Operation operation) {
            this.id = Mth.m_14062_((Random)new Random(name.hashCode())).toString();
            this.name = name;
            this.amount = amount;
            this.operation = operation.m_22235_();
        }

        public AttributeModifier.Operation getOperation() {
            return AttributeModifier.Operation.m_22236_((int)this.operation);
        }

        public AttributeModifier toMCModifier() {
            return new AttributeModifier(UUID.fromString(this.id), this.name, this.amount, this.getOperation());
        }
    }
}

