/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type;

import com.google.gson.annotations.Expose;
import iskallia.vault.skill.talent.TalentTree;
import iskallia.vault.skill.talent.type.PlayerTalent;
import iskallia.vault.world.data.PlayerFavourData;
import iskallia.vault.world.data.PlayerTalentsData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ExperiencedTalent
extends PlayerTalent {
    @Expose
    private final float increasedExpPercentage;

    public ExperiencedTalent(int cost, float increasedExpPercentage) {
        super(cost);
        this.increasedExpPercentage = increasedExpPercentage;
    }

    public float getIncreasedExpPercentage() {
        return this.increasedExpPercentage;
    }

    @SubscribeEvent
    public static void onOrbPickup(PlayerXpEvent.PickupXp event) {
        if (!(event.getPlayer() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        TalentTree talents = PlayerTalentsData.get(player.m_183503_()).getTalents((Player)player);
        ExperienceOrb orb = event.getOrb();
        float increase = 0.0f;
        for (ExperiencedTalent talent : talents.getTalents(ExperiencedTalent.class)) {
            increase += talent.getIncreasedExpPercentage();
        }
        int favour = PlayerFavourData.get(player.m_183503_()).getFavour(player.m_142081_(), PlayerFavourData.VaultGodType.OMNISCIENT);
        if (favour >= 4) {
            increase += (float)favour * 0.2f;
        } else if (favour <= -4) {
            increase -= (float)Math.min(Math.abs(favour), 8) * 0.0625f;
        }
        orb.f_20770_ = (int)((float)orb.f_20770_ * (1.0f + increase));
    }
}

