/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type;

import com.google.gson.annotations.Expose;
import iskallia.vault.skill.talent.TalentNode;
import iskallia.vault.skill.talent.TalentTree;
import iskallia.vault.skill.talent.type.PlayerTalent;
import iskallia.vault.world.data.PlayerTalentsData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class ConditionalDamageTalent
extends PlayerTalent {
    @Expose
    private final ResourceLocation targetEffect;
    @Expose
    private final double damageIncrease;

    public ConditionalDamageTalent(int cost, MobEffect targetEffect, double damageIncrease) {
        super(cost);
        this.targetEffect = targetEffect.getRegistryName();
        this.damageIncrease = damageIncrease;
    }

    public MobEffect getTargetEffect() {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.targetEffect);
    }

    public double getDamageIncrease() {
        return this.damageIncrease;
    }

    @SubscribeEvent
    public static void onAttack(LivingHurtEvent event) {
        Entity attackingEntity = event.getSource().m_7639_();
        if (!(attackingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)attackingEntity;
        LivingEntity attacked = event.getEntityLiving();
        float addedMultiplier = 0.0f;
        TalentTree talents = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
        for (TalentNode<ConditionalDamageTalent> talentNode : talents.getLearnedNodes(ConditionalDamageTalent.class)) {
            ConditionalDamageTalent talent = talentNode.getTalent();
            if (talent.getTargetEffect() == null || !attacked.m_21023_(talent.getTargetEffect())) continue;
            addedMultiplier = (float)((double)addedMultiplier + talent.getDamageIncrease());
        }
        event.setAmount(event.getAmount() * (1.0f + addedMultiplier));
    }
}

