/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.group;

import com.google.gson.annotations.Expose;
import iskallia.vault.skill.ability.config.VeinMinerConfig;
import iskallia.vault.skill.ability.config.sub.VeinMinerDurabilityConfig;
import iskallia.vault.skill.ability.config.sub.VeinMinerFortuneConfig;
import iskallia.vault.skill.ability.config.sub.VeinMinerVoidConfig;
import iskallia.vault.skill.ability.effect.VeinMinerAbility;
import iskallia.vault.skill.ability.group.AbilityGroup;
import java.util.ArrayList;
import java.util.List;

public class VeinMinerAbilityGroup
extends AbilityGroup<VeinMinerConfig, VeinMinerAbility<VeinMinerConfig>> {
    @Expose
    private final List<VeinMinerDurabilityConfig> durabilityLevelConfiguration = new ArrayList<VeinMinerDurabilityConfig>();
    @Expose
    private final List<VeinMinerFortuneConfig> fortuneLevelConfiguration = new ArrayList<VeinMinerFortuneConfig>();
    @Expose
    private final List<VeinMinerVoidConfig> voidLevelConfiguration = new ArrayList<VeinMinerVoidConfig>();

    private VeinMinerAbilityGroup() {
        super("Vein Miner");
    }

    @Override
    protected VeinMinerConfig getSubConfig(String specialization, int level) {
        return switch (specialization) {
            case "Vein Miner_Durability" -> this.durabilityLevelConfiguration.get(level);
            case "Vein Miner_Fortune" -> this.fortuneLevelConfiguration.get(level);
            case "Vein Miner_Void" -> this.voidLevelConfiguration.get(level);
            default -> null;
        };
    }

    @Override
    public String getSpecializationName(String specialization) {
        return switch (specialization) {
            case "Vein Miner_Durability" -> "Finesse";
            case "Vein Miner_Fortune" -> "Fortune";
            case "Vein Miner_Void" -> "Void";
            default -> "Vein Miner";
        };
    }

    public static VeinMinerAbilityGroup defaultConfig() {
        VeinMinerAbilityGroup group = new VeinMinerAbilityGroup();
        for (int i = 0; i < 5; ++i) {
            int blockLimit = (int)Math.pow(2.0, i + 2);
            group.addLevel(new VeinMinerConfig(1, 1, 10, 1, blockLimit));
            group.durabilityLevelConfiguration.add(new VeinMinerDurabilityConfig(1, 1, 10, 1, blockLimit, 1 + i));
            group.fortuneLevelConfiguration.add(new VeinMinerFortuneConfig(1, 1, 10, 1, blockLimit, 1 + i));
            group.voidLevelConfiguration.add(new VeinMinerVoidConfig(1, 1, 10, 1, blockLimit));
        }
        return group;
    }

    @Override
    public boolean isConfigurationValid() {
        return this.areListsEqualSize(this.levelConfiguration, this.durabilityLevelConfiguration, this.fortuneLevelConfiguration, this.voidLevelConfiguration);
    }
}

