/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.group;

import com.google.gson.annotations.Expose;
import iskallia.vault.skill.ability.config.TauntConfig;
import iskallia.vault.skill.ability.config.sub.TauntRepelConfig;
import iskallia.vault.skill.ability.effect.TauntAbility;
import iskallia.vault.skill.ability.group.AbilityGroup;
import java.util.ArrayList;
import java.util.List;

public class TauntAbilityGroup
extends AbilityGroup<TauntConfig, TauntAbility> {
    @Expose
    private final List<TauntRepelConfig> repelLevelConfiguration = new ArrayList<TauntRepelConfig>();

    protected TauntAbilityGroup() {
        super("Taunt");
    }

    @Override
    protected TauntConfig getSubConfig(String specialization, int level) {
        return switch (specialization) {
            case "Taunt_Repel" -> this.repelLevelConfiguration.get(level);
            default -> null;
        };
    }

    @Override
    public String getSpecializationName(String specialization) {
        return switch (specialization) {
            case "Taunt_Repel" -> "Fear";
            default -> "Taunt";
        };
    }

    public static TauntAbilityGroup defaultConfig() {
        TauntAbilityGroup group = new TauntAbilityGroup();
        for (int i = 0; i < 5; ++i) {
            group.addLevel(new TauntConfig(1, 1, 10, 1, 1.0f, 10.0f, 400));
            group.repelLevelConfiguration.add(new TauntRepelConfig(1, 1, 10, 1, 1.0f, 10.0f, 400, 10.0f));
        }
        return group;
    }

    @Override
    public boolean isConfigurationValid() {
        return this.areListsEqualSize(this.levelConfiguration, this.repelLevelConfiguration);
    }
}

