/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.group;

import com.google.gson.annotations.Expose;
import iskallia.vault.skill.ability.config.TankConfig;
import iskallia.vault.skill.ability.config.sub.TankProjectileConfig;
import iskallia.vault.skill.ability.config.sub.TankReflectConfig;
import iskallia.vault.skill.ability.effect.TankAbility;
import iskallia.vault.skill.ability.group.AbilityGroup;
import java.util.ArrayList;
import java.util.List;

public class TankAbilityGroup
extends AbilityGroup<TankConfig, TankAbility> {
    @Expose
    private final List<TankProjectileConfig> projectileLevelConfiguration = new ArrayList<TankProjectileConfig>();
    @Expose
    private final List<TankReflectConfig> reflectLevelConfiguration = new ArrayList<TankReflectConfig>();

    private TankAbilityGroup() {
        super("Tank");
    }

    @Override
    protected TankConfig getSubConfig(String specialization, int level) {
        return switch (specialization) {
            case "Tank_Projectile" -> this.projectileLevelConfiguration.get(level);
            case "Tank_Reflect" -> this.reflectLevelConfiguration.get(level);
            default -> null;
        };
    }

    @Override
    public String getSpecializationName(String specialization) {
        return switch (specialization) {
            case "Tank_Projectile" -> "Rock";
            case "Tank_Reflect" -> "Porcupine";
            default -> "Tank";
        };
    }

    public static TankAbilityGroup defaultConfig() {
        TankAbilityGroup group = new TankAbilityGroup();
        for (int i = 0; i < 5; ++i) {
            group.addLevel(new TankConfig(1, 1, 10, 1, 1.0f, 100, 0.05f, 0.5f));
            group.projectileLevelConfiguration.add(new TankProjectileConfig(1, 1, 10, 1, 1.0f, 1.0f, 0.1f * (float)i));
            group.reflectLevelConfiguration.add(new TankReflectConfig(1, 1, 10, 1, 1.0f, 0.1f + 0.1f * (float)i, 0.1f + 0.1f * (float)i));
        }
        return group;
    }

    @Override
    public boolean isConfigurationValid() {
        return this.areListsEqualSize(this.levelConfiguration, this.projectileLevelConfiguration, this.reflectLevelConfiguration);
    }
}

