/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.group;

import com.google.gson.annotations.Expose;
import iskallia.vault.skill.ability.config.NovaConfig;
import iskallia.vault.skill.ability.config.sub.NovaDotConfig;
import iskallia.vault.skill.ability.config.sub.NovaSpeedConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbstractAbility;
import iskallia.vault.skill.ability.group.AbilityGroup;
import java.util.ArrayList;
import java.util.List;

public class NovaAbilityGroup
extends AbilityGroup<NovaConfig, AbstractAbility<NovaConfig>> {
    @Expose
    private final List<NovaSpeedConfig> speedLevelConfiguration = new ArrayList<NovaSpeedConfig>();
    @Expose
    private final List<NovaDotConfig> damageLevelConfiguration = new ArrayList<NovaDotConfig>();

    protected NovaAbilityGroup() {
        super("Nova");
    }

    @Override
    protected NovaConfig getSubConfig(String specialization, int level) {
        return switch (specialization) {
            case "Nova_Speed" -> this.speedLevelConfiguration.get(level);
            case "Nova_Dot" -> this.damageLevelConfiguration.get(level);
            default -> null;
        };
    }

    @Override
    public String getSpecializationName(String specialization) {
        return switch (specialization) {
            case "Nova_Speed" -> "Frost";
            case "Nova_Dot" -> "Poison";
            default -> "Nova";
        };
    }

    public static NovaAbilityGroup defaultConfig() {
        NovaAbilityGroup group = new NovaAbilityGroup();
        for (int i = 0; i < 10; ++i) {
            group.addLevel(new NovaConfig(1, 1, 10, 1, 10.0f, 10.0f, 0.5f, 0.0f));
            group.speedLevelConfiguration.add(new NovaSpeedConfig(1, 1, 10, 1, 10.0f, 10.0f, 400, 20));
            group.damageLevelConfiguration.add(new NovaDotConfig(1, 1, 10, 1, 10.0f, 10.0f, 1.0f, 5));
        }
        return group;
    }

    @Override
    public boolean isConfigurationValid() {
        return this.areListsEqualSize(this.levelConfiguration, this.speedLevelConfiguration, this.damageLevelConfiguration);
    }
}

