/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.group;

import com.google.gson.annotations.Expose;
import iskallia.vault.skill.ability.config.MegaJumpConfig;
import iskallia.vault.skill.ability.config.sub.MegaJumpBreakDownConfig;
import iskallia.vault.skill.ability.config.sub.MegaJumpBreakUpConfig;
import iskallia.vault.skill.ability.effect.MegaJumpAbility;
import iskallia.vault.skill.ability.group.AbilityGroup;
import java.util.ArrayList;
import java.util.List;

public class MegaJumpAbilityGroup
extends AbilityGroup<MegaJumpConfig, MegaJumpAbility<MegaJumpConfig>> {
    @Expose
    private final List<MegaJumpBreakUpConfig> breakUpLevelConfiguration = new ArrayList<MegaJumpBreakUpConfig>();
    @Expose
    private final List<MegaJumpBreakDownConfig> breakDownLevelConfiguration = new ArrayList<MegaJumpBreakDownConfig>();

    private MegaJumpAbilityGroup() {
        super("Mega Jump");
    }

    @Override
    protected MegaJumpConfig getSubConfig(String specialization, int level) {
        return switch (specialization) {
            case "Mega Jump_Break_Up" -> this.breakUpLevelConfiguration.get(level);
            case "Mega Jump_Break_Down" -> this.breakDownLevelConfiguration.get(level);
            default -> null;
        };
    }

    @Override
    public String getSpecializationName(String specialization) {
        return switch (specialization) {
            case "Mega Jump_Break_Up" -> "Drill";
            case "Mega Jump_Break_Down" -> "Dig";
            default -> "Mega Jump";
        };
    }

    public static MegaJumpAbilityGroup defaultConfig() {
        MegaJumpAbilityGroup group = new MegaJumpAbilityGroup();
        for (int i = 0; i < 3; ++i) {
            group.addLevel(new MegaJumpConfig(1, 1, 10, 1, 10.0f, 10 + i));
            group.breakUpLevelConfiguration.add(new MegaJumpBreakUpConfig(1, 1, 10, 1, 10.0f, 10 + i));
            group.breakDownLevelConfiguration.add(new MegaJumpBreakDownConfig(1, 1, 10, 1, 10.0f, 10 + i));
        }
        return group;
    }

    @Override
    public boolean isConfigurationValid() {
        return this.areListsEqualSize(this.levelConfiguration, this.breakUpLevelConfiguration, this.breakDownLevelConfiguration);
    }
}

