/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.group;

import com.google.gson.annotations.Expose;
import iskallia.vault.skill.ability.config.HealConfig;
import iskallia.vault.skill.ability.config.sub.HealEffectConfig;
import iskallia.vault.skill.ability.config.sub.HealGroupConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbstractAbility;
import iskallia.vault.skill.ability.group.AbilityGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraftforge.registries.ForgeRegistries;

public class HealAbilityGroup
extends AbilityGroup<HealConfig, AbstractAbility<HealConfig>> {
    @Expose
    private final List<HealEffectConfig> effectLevelConfiguration = new ArrayList<HealEffectConfig>();
    @Expose
    private final List<HealGroupConfig> groupLevelConfiguration = new ArrayList<HealGroupConfig>();

    protected HealAbilityGroup() {
        super("Heal");
    }

    @Override
    protected HealConfig getSubConfig(String specialization, int level) {
        return switch (specialization) {
            case "Heal_Effect" -> this.effectLevelConfiguration.get(level);
            case "Heal_Group" -> this.groupLevelConfiguration.get(level);
            default -> null;
        };
    }

    @Override
    public String getSpecializationName(String specialization) {
        return switch (specialization) {
            case "Heal_Effect" -> "Cleanse";
            case "Heal_Group" -> "Aid";
            default -> "Heal";
        };
    }

    public static HealAbilityGroup defaultConfig() {
        HealAbilityGroup group = new HealAbilityGroup();
        int defaultLevelCount = 10;
        List<MobEffect> mobEffectList = ForgeRegistries.MOB_EFFECTS.getValues().stream().filter(effect -> effect.m_19483_() == MobEffectCategory.HARMFUL).collect(Collectors.toList());
        for (int i = 0; i < 10; ++i) {
            group.addLevel(new HealConfig(1, 1, 10, 1, 10.0f, 5.0f));
            group.effectLevelConfiguration.add(new HealEffectConfig(1, 1, 10, 1, 10.0f, mobEffectList));
            group.groupLevelConfiguration.add(new HealGroupConfig(1, 1, 10, 1, 10.0f, 5.0f, 5.0f));
        }
        return group;
    }

    @Override
    public boolean isConfigurationValid() {
        return this.areListsEqualSize(this.levelConfiguration, this.effectLevelConfiguration, this.groupLevelConfiguration);
    }
}

