/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.group;

import com.google.gson.annotations.Expose;
import iskallia.vault.skill.ability.config.DashConfig;
import iskallia.vault.skill.ability.config.sub.DashDamageConfig;
import iskallia.vault.skill.ability.effect.DashAbility;
import iskallia.vault.skill.ability.group.AbilityGroup;
import java.util.ArrayList;
import java.util.List;

public class DashAbilityGroup
extends AbilityGroup<DashConfig, DashAbility<DashConfig>> {
    @Expose
    private final List<DashDamageConfig> damageLevelConfiguration = new ArrayList<DashDamageConfig>();

    private DashAbilityGroup() {
        super("Dash");
    }

    @Override
    protected DashConfig getSubConfig(String specialization, int level) {
        return switch (specialization) {
            case "Dash_Damage" -> this.damageLevelConfiguration.get(level);
            default -> null;
        };
    }

    @Override
    public String getSpecializationName(String specialization) {
        return switch (specialization) {
            case "Dash_Damage" -> "Bullet";
            default -> "Dash";
        };
    }

    public static DashAbilityGroup defaultConfig() {
        DashAbilityGroup group = new DashAbilityGroup();
        for (int i = 0; i < 10; ++i) {
            group.addLevel(new DashConfig(1, 1, 10, 1, 10.0f, 10));
            group.damageLevelConfiguration.add(new DashDamageConfig(1, 1, 10, 1, 10.0f, 10, 0.5f));
        }
        return group;
    }

    @Override
    public boolean isConfigurationValid() {
        return this.areListsEqualSize(this.levelConfiguration, this.damageLevelConfiguration);
    }
}

