/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.group;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.annotations.Expose;
import iskallia.vault.skill.ability.AbilityRegistry;
import iskallia.vault.skill.ability.config.spi.AbstractAbilityConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbstractAbility;
import iskallia.vault.util.RomanNumber;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;

public abstract class AbilityGroup<T extends AbstractAbilityConfig, E extends AbstractAbility<T>> {
    @Expose
    protected final String name;
    @Expose
    protected final List<T> levelConfiguration = new ArrayList<T>();
    private final BiMap<Integer, String> nameCache = HashBiMap.create();

    protected AbilityGroup(String name) {
        this.name = name;
    }

    public int getMaxLevel() {
        return this.levelConfiguration.size();
    }

    protected void addLevel(T config) {
        this.levelConfiguration.add(config);
    }

    public String getParentName() {
        return this.name;
    }

    public String getName(int level) {
        return (String)this.getNameCache().get((Object)level);
    }

    public T getAbilityConfig(@Nullable String specialization, int level) {
        T config;
        if (level < 0) {
            return this.getDefaultConfig(0);
        }
        level = Math.min(level, this.getMaxLevel() - 1);
        if (specialization != null && (config = this.getSubConfig(specialization, level)) != null) {
            return config;
        }
        return this.getDefaultConfig(level);
    }

    public boolean hasSpecialization(String specialization) {
        return this.getSubConfig(specialization, 0) != null;
    }

    protected abstract T getSubConfig(String var1, int var2);

    public abstract String getSpecializationName(String var1);

    private T getDefaultConfig(int level) {
        return (T)((AbstractAbilityConfig)this.levelConfiguration.get(Mth.m_14045_((int)level, (int)0, (int)(this.getMaxLevel() - 1))));
    }

    @Nullable
    public E getAbility(@Nullable String specialization) {
        return (E)AbilityRegistry.getAbility(specialization == null ? this.getParentName() : specialization);
    }

    public int learningCost() {
        return ((AbstractAbilityConfig)this.getDefaultConfig(0)).getLearningCost();
    }

    public int levelUpCost(@Nullable String specialization, int toLevel) {
        if (toLevel > this.getMaxLevel()) {
            return -1;
        }
        return ((AbstractAbilityConfig)this.getAbilityConfig(specialization, toLevel - 1)).getLearningCost();
    }

    private BiMap<Integer, String> getNameCache() {
        if (this.nameCache.isEmpty()) {
            for (int i = 1; i <= this.getMaxLevel(); ++i) {
                this.nameCache.put((Object)i, (Object)(this.getParentName() + " " + RomanNumber.toRoman(i)));
            }
        }
        return this.nameCache;
    }

    public abstract boolean isConfigurationValid();

    protected boolean areListsEqualSize(List<?> list, List<?> ... specLists) {
        for (List<?> specList : specLists) {
            if (list.size() == specList.size()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbilityGroup that = (AbilityGroup)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

