/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.sub;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.PlayerStatEvent;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.config.sub.TankReflectConfig;
import iskallia.vault.skill.ability.effect.spi.AbstractTankAbility;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.AbilityTickResult;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbilityEffect;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TankReflectAbility
extends AbstractTankAbility<TankReflectConfig> {
    public TankReflectAbility() {
        ((PlayerStatEvent)CommonEvents.PLAYER_STAT.of(PlayerStat.THORNS_CHANCE).filter(data -> this.getConfig(data.getEntity()).isPresent())).register(this, data -> this.getConfig(data.getEntity()).ifPresent(config -> data.setValue(data.getValue() + config.getAdditionalThornsChance())));
        ((PlayerStatEvent)CommonEvents.PLAYER_STAT.of(PlayerStat.THORNS_DAMAGE).filter(data -> this.getConfig(data.getEntity()).isPresent())).register(this, data -> this.getConfig(data.getEntity()).ifPresent(config -> data.setValue(data.getValue() + config.getThornsDamageMultiplier())));
    }

    private Optional<TankReflectConfig> getConfig(LivingEntity livingEntity) {
        Object obj;
        ServerPlayer player;
        if (!(livingEntity instanceof ServerPlayer) || !(player = (ServerPlayer)livingEntity).m_21023_((MobEffect)ModEffects.TANK_REFLECT)) {
            return Optional.empty();
        }
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        AbilityNode<?, ?> node = abilities.getNodeByName("Tank");
        if (node.getAbility() != this || !node.isLearned() || !((obj = node.getAbilityConfig()) instanceof TankReflectConfig)) {
            return Optional.empty();
        }
        TankReflectConfig config = (TankReflectConfig)obj;
        return Optional.of(config);
    }

    @Override
    protected AbilityActionResult doToggle(TankReflectConfig config, ServerPlayer player, boolean active) {
        if (active) {
            ModEffects.TANK_REFLECT.addTo((LivingEntity)player, 0);
            return AbilityActionResult.SUCCESS_COOLDOWN_DEFERRED;
        }
        player.m_21195_((MobEffect)ModEffects.TANK_REFLECT);
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    protected void doToggleSound(TankReflectConfig config, ServerPlayer player, boolean active) {
        if (active) {
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.TANK_REFLECT, SoundSource.MASTER, 0.7f, 1.0f);
            player.m_6330_(ModSounds.TANK_REFLECT, SoundSource.MASTER, 0.7f, 1.0f);
        }
    }

    @Override
    protected AbilityTickResult doInactiveTick(TankReflectConfig config, ServerPlayer player) {
        if (player.m_21023_((MobEffect)ModEffects.TANK_REFLECT)) {
            player.m_21195_((MobEffect)ModEffects.TANK_REFLECT);
        }
        return AbilityTickResult.PASS;
    }

    @Override
    protected void doManaDepleted(TankReflectConfig config, ServerPlayer player) {
        player.m_21195_((MobEffect)ModEffects.TANK_REFLECT);
    }

    @SubscribeEvent
    public void on(LivingDamageEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof ServerPlayer) || !(player = (ServerPlayer)livingEntity).m_21023_((MobEffect)ModEffects.TANK_REFLECT)) {
            return;
        }
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        AbilityNode<?, ?> node = abilities.getNodeByName("Tank");
        if (node.getAbility() != this || !node.isLearned()) {
            return;
        }
        if (event.getSource().m_7639_() instanceof LivingEntity) {
            float pitch = 1.0f + RANDOM.nextFloat() * 0.25f;
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.TANK_REFLECT_HIT, SoundSource.MASTER, 0.3f, pitch);
            player.m_6330_(ModSounds.TANK_REFLECT_HIT, SoundSource.MASTER, 0.3f, pitch);
        } else {
            float pitch = 1.0f + (RANDOM.nextFloat() * 0.5f - 0.5f);
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.TANK_HIT, SoundSource.MASTER, 0.3f, pitch);
            player.m_6330_(ModSounds.TANK_HIT, SoundSource.MASTER, 0.3f, pitch);
        }
    }

    public static class TankReflectEffect
    extends ToggleAbilityEffect {
        public TankReflectEffect(int color, ResourceLocation resourceLocation) {
            super("Tank", color, resourceLocation);
        }
    }
}

