/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.sub;

import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.config.sub.TankProjectileConfig;
import iskallia.vault.skill.ability.effect.spi.AbstractTankAbility;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.AbilityTickResult;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbilityEffect;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TankProjectileAbility
extends AbstractTankAbility<TankProjectileConfig> {
    @Override
    protected AbilityActionResult doToggle(TankProjectileConfig config, ServerPlayer player, boolean active) {
        if (active) {
            int amplifier = (int)Mth.m_14036_((float)(config.getKnockbackResistance() * 100.0f), (float)0.0f, (float)100.0f);
            ModEffects.TANK_PROJECTILE.addTo((LivingEntity)player, amplifier);
            return AbilityActionResult.SUCCESS_COOLDOWN_DEFERRED;
        }
        player.m_21195_((MobEffect)ModEffects.TANK_PROJECTILE);
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    protected void doToggleSound(TankProjectileConfig config, ServerPlayer player, boolean active) {
        if (active) {
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.TANK_PROJECTILE, SoundSource.MASTER, 0.7f, 1.0f);
            player.m_6330_(ModSounds.TANK_PROJECTILE, SoundSource.MASTER, 0.7f, 1.0f);
        }
    }

    @Override
    protected AbilityTickResult doInactiveTick(TankProjectileConfig config, ServerPlayer player) {
        if (player.m_21023_((MobEffect)ModEffects.TANK_PROJECTILE)) {
            player.m_21195_((MobEffect)ModEffects.TANK_PROJECTILE);
        }
        return AbilityTickResult.PASS;
    }

    @Override
    protected void doManaDepleted(TankProjectileConfig config, ServerPlayer player) {
        player.m_21195_((MobEffect)ModEffects.TANK_PROJECTILE);
    }

    @SubscribeEvent
    public void on(LivingDamageEvent event) {
        Object obj;
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof ServerPlayer) || !(player = (ServerPlayer)livingEntity).m_21023_((MobEffect)ModEffects.TANK_PROJECTILE)) {
            return;
        }
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        AbilityNode<?, ?> node = abilities.getNodeByName("Tank");
        if (node.getAbility() != this || !node.isLearned() || !((obj = node.getAbilityConfig()) instanceof TankProjectileConfig)) {
            return;
        }
        TankProjectileConfig config = (TankProjectileConfig)obj;
        if (event.getSource().m_19360_()) {
            float percentageReduced = Mth.m_14036_((float)config.getPercentageReducedProjectileDamage(), (float)0.0f, (float)1.0f);
            if (Mth.m_14033_((float)percentageReduced, (float)1.0f)) {
                event.setCanceled(true);
            } else if (!Mth.m_14033_((float)percentageReduced, (float)0.0f)) {
                float amount = event.getAmount();
                event.setAmount(amount - amount * percentageReduced);
            }
        }
        float pitch = 1.0f + (RANDOM.nextFloat() * 0.5f - 0.5f);
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.TANK_PROJECTILE_HIT, SoundSource.MASTER, 0.3f, pitch);
        player.m_6330_(ModSounds.TANK_PROJECTILE_HIT, SoundSource.MASTER, 0.3f, pitch);
    }

    public static class TankProjectileEffect
    extends ToggleAbilityEffect {
        public TankProjectileEffect(int color, ResourceLocation resourceLocation) {
            super("Tank", color, resourceLocation);
            this.m_19472_(Attributes.f_22278_, Mth.m_14062_((Random)new Random(resourceLocation.hashCode())).toString(), 0.01, AttributeModifier.Operation.ADDITION);
        }
    }
}

