/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.sub;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.PlayerStatEvent;
import iskallia.vault.init.ModEffects;
import iskallia.vault.skill.ability.config.sub.RampageLeechConfig;
import iskallia.vault.skill.ability.effect.spi.AbstractRampageAbility;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbilityEffect;
import iskallia.vault.util.calc.PlayerStat;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;

public class RampageLeechAbility
extends AbstractRampageAbility<RampageLeechConfig> {
    public RampageLeechAbility() {
        ((PlayerStatEvent)CommonEvents.PLAYER_STAT.of(PlayerStat.LEECH).filter(data -> data.getEntity().m_21023_((MobEffect)ModEffects.RAMPAGE_LEECH))).register(this, data -> {
            int amplifier = data.getEntity().m_21124_((MobEffect)ModEffects.RAMPAGE_LEECH).m_19564_();
            float leechPercent = (float)amplifier / 100.0f;
            data.setValue(data.getValue() + leechPercent);
        });
    }

    @Override
    protected AbilityActionResult doToggle(RampageLeechConfig config, ServerPlayer player, boolean active) {
        if (active) {
            int amplifier = (int)Mth.m_14036_((float)(config.getLeechPercent() * 100.0f), (float)0.0f, (float)100.0f);
            ModEffects.RAMPAGE_LEECH.addTo((LivingEntity)player, amplifier);
            return AbilityActionResult.SUCCESS_COOLDOWN_DEFERRED;
        }
        player.m_21195_((MobEffect)ModEffects.RAMPAGE_LEECH);
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    protected void doManaDepleted(RampageLeechConfig config, ServerPlayer player) {
        player.m_21195_((MobEffect)ModEffects.RAMPAGE_LEECH);
    }

    public static class RampageLeechEffect
    extends ToggleAbilityEffect {
        public RampageLeechEffect(int color, ResourceLocation resourceLocation) {
            super("Rampage", color, resourceLocation);
        }
    }
}

