/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.sub;

import iskallia.vault.init.ModParticles;
import iskallia.vault.skill.ability.config.sub.NovaDotConfig;
import iskallia.vault.skill.ability.effect.spi.AbstractNovaAbility;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.util.damage.DamageOverTimeHelper;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potions;

public class NovaDotAbility
extends AbstractNovaAbility<NovaDotConfig> {
    private static final int PARTICLE_COLOR = TextColor.m_131268_((String)"#5e8a37").m_131265_();

    @Override
    protected AbilityActionResult doAction(NovaDotConfig config, ServerPlayer player, boolean active) {
        List<LivingEntity> targetEntities = this.getTargetEntities(config, player);
        float attackDamage = this.getAttackDamage(config, player);
        for (LivingEntity targetEntity : targetEntities) {
            DamageOverTimeHelper.invalidateAll(targetEntity);
            DamageOverTimeHelper.applyDamageOverTime(targetEntity, (DamageSource)PlayerDamageOverTimeSource.of((Player)player), attackDamage, config.getDurationSeconds() * 20);
        }
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    protected void doParticles(NovaDotConfig config, ServerPlayer player) {
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_());
        areaEffectCloud.m_19718_((LivingEntity)player);
        areaEffectCloud.m_19712_(config.getRadius());
        areaEffectCloud.m_19732_(-0.5f);
        areaEffectCloud.m_19740_(0);
        areaEffectCloud.m_19734_(4);
        areaEffectCloud.m_19722_(Potions.f_43598_);
        areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
        areaEffectCloud.m_19714_(PARTICLE_COLOR);
        areaEffectCloud.m_19724_((ParticleOptions)ModParticles.NOVA_DOT.get());
        player.f_19853_.m_7967_((Entity)areaEffectCloud);
    }

    @Override
    protected void doSound(NovaDotConfig config, ServerPlayer player) {
        player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12436_, SoundSource.PLAYERS, 0.2f, 1.0f);
        player.m_6330_(SoundEvents.f_12436_, SoundSource.PLAYERS, 0.2f, 1.0f);
    }

    public static class PlayerDamageOverTimeSource
    extends EntityDamageSource {
        private PlayerDamageOverTimeSource(Entity damageSource) {
            super("player", damageSource);
        }

        public static PlayerDamageOverTimeSource of(Player player) {
            return new PlayerDamageOverTimeSource((Entity)player);
        }
    }
}

