/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.sub;

import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.config.sub.MegaJumpBreakUpConfig;
import iskallia.vault.skill.ability.effect.MegaJumpAbility;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.ServerVaults;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MegaJumpBreakUpAbility
extends MegaJumpAbility<MegaJumpBreakUpConfig> {
    private final Map<UUID, Integer> playerBreakMap = new HashMap<UUID, Integer>();

    @Override
    protected boolean canDoAction(MegaJumpBreakUpConfig config, ServerPlayer player, boolean active) {
        return super.canDoAction(config, player, active) && ServerVaults.isInVault((Entity)player);
    }

    @Override
    protected AbilityActionResult doAction(MegaJumpBreakUpConfig config, ServerPlayer player, boolean active) {
        super.doAction(config, player, active);
        this.playerBreakMap.put(player.m_142081_(), 30);
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player.m_20193_().m_5776_() || !(event.player.m_20193_() instanceof ServerLevel)) {
            return;
        }
        Player player = event.player;
        UUID plUUID = player.m_142081_();
        if (!this.playerBreakMap.containsKey(plUUID)) {
            return;
        }
        int ticks = this.playerBreakMap.get(plUUID);
        if (--ticks <= 0) {
            this.playerBreakMap.remove(plUUID);
            return;
        }
        this.playerBreakMap.put(plUUID, ticks);
        ServerLevel sWorld = (ServerLevel)player.m_20193_();
        AbilityTree abilityTree = PlayerAbilitiesData.get(sWorld).getAbilities(player);
        AbilityNode<?, ?> focusedAbilityNode = abilityTree.getSelectedAbility();
        if (focusedAbilityNode != null && focusedAbilityNode.getAbility() == this) {
            for (BlockPos offset : BlockHelper.getOvalPositions(player.m_142538_().m_6630_(3), 4.0f, 6.0f)) {
                float hardness;
                BlockState state = sWorld.m_8055_(offset);
                if (state.m_60795_() || state.m_60834_() && !TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.IRON, (BlockState)state) || !((hardness = state.m_60800_((BlockGetter)sWorld, offset)) >= 0.0f) || !(hardness <= 25.0f)) continue;
                this.destroyBlock(sWorld, offset, player);
            }
        }
    }

    private void destroyBlock(ServerLevel world, BlockPos pos, Player player) {
        ItemStack miningItem = new ItemStack((ItemLike)Items.f_42390_);
        Block.m_49881_((BlockState)world.m_8055_(pos), (Level)world, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), null, (ItemStack)miningItem);
        world.m_46953_(pos, false, (Entity)player);
    }
}

