/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.sub;

import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.config.sub.MegaJumpBreakDownConfig;
import iskallia.vault.skill.ability.effect.MegaJumpAbility;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.ServerVaults;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;

public class MegaJumpBreakDownAbility
extends MegaJumpAbility<MegaJumpBreakDownConfig> {
    @Override
    protected boolean canDoAction(MegaJumpBreakDownConfig config, ServerPlayer player, boolean active) {
        return super.canDoAction(config, player, active) && ServerVaults.isInVault((Entity)player);
    }

    @Override
    protected AbilityActionResult doAction(MegaJumpBreakDownConfig config, ServerPlayer player, boolean active) {
        double magnitude = (double)config.getHeight() * 0.15;
        double addY = -Math.min(0.0, player.m_20184_().m_7098_());
        player.m_5997_(0.0, -(addY + magnitude), 0.0);
        player.m_36320_();
        player.f_19864_ = true;
        this.breakBlocks(config, player);
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    private void breakBlocks(MegaJumpBreakDownConfig config, ServerPlayer player) {
        ServerLevel sWorld = (ServerLevel)player.m_20193_();
        AbilityTree abilityTree = PlayerAbilitiesData.get(sWorld).getAbilities((Player)player);
        AbilityNode<?, ?> focusedAbilityNode = abilityTree.getSelectedAbility();
        if (focusedAbilityNode != null && focusedAbilityNode.getAbility() == this) {
            for (BlockPos offset : BlockHelper.getOvalPositions(player.m_142538_().m_6625_(3), 4.0f, config.getHeight())) {
                float hardness;
                BlockState state = sWorld.m_8055_(offset);
                if (state.m_60795_() || state.m_60834_() && !TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.IRON, (BlockState)state) || !((hardness = state.m_60800_((BlockGetter)sWorld, offset)) >= 0.0f) || !(hardness <= 25.0f)) continue;
                this.destroyBlock(sWorld, offset, (Player)player);
            }
        }
    }

    private void destroyBlock(ServerLevel world, BlockPos pos, Player player) {
        ItemStack miningItem = new ItemStack((ItemLike)Items.f_42390_);
        Block.m_49881_((BlockState)world.m_8055_(pos), (Level)world, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), null, (ItemStack)miningItem);
        world.m_46953_(pos, false, (Entity)player);
    }
}

