/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.sub;

import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.config.sub.HealEffectConfig;
import iskallia.vault.skill.ability.effect.spi.AbstractHealAbility;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.player.Player;

public class HealEffectAbility
extends AbstractHealAbility<HealEffectConfig> {
    private final IRemovalStrategy removalStrategy;

    public HealEffectAbility(IRemovalStrategy removalStrategy) {
        this.removalStrategy = removalStrategy;
    }

    @Override
    protected AbilityActionResult doAction(HealEffectConfig config, ServerPlayer player, boolean active) {
        this.removalStrategy.apply(player, config);
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    protected void doParticles(HealEffectConfig config, ServerPlayer player) {
        ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123772_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 1.0, 0.5, 1.0, 0.0);
        ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123748_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 1.0, 0.5, 1.0, 0.0);
    }

    @Override
    protected void doSound(HealEffectConfig config, ServerPlayer player) {
        player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.CLEANSE_SFX, SoundSource.PLAYERS, 0.2f, 1.0f);
        player.m_6330_(ModSounds.CLEANSE_SFX, SoundSource.PLAYERS, 0.2f, 1.0f);
    }

    @FunctionalInterface
    private static interface IRemovalStrategy {
        public void apply(ServerPlayer var1, HealEffectConfig var2);
    }

    public static enum RemovalStrategy implements IRemovalStrategy
    {
        DEFINED_ONLY((player, config) -> config.getRemoveEffects().forEach(arg_0 -> ((ServerPlayer)player).m_21195_(arg_0))),
        ALL_HARMFUL((player, config) -> player.m_21220_().stream().filter(instance -> instance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL).forEach(instance -> player.m_21195_(instance.m_19544_())));

        private final IRemovalStrategy removalStrategy;

        private RemovalStrategy(IRemovalStrategy removalStrategy) {
            this.removalStrategy = removalStrategy;
        }

        @Override
        public void apply(ServerPlayer player, HealEffectConfig config) {
            this.removalStrategy.apply(player, config);
        }
    }
}

