/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.sub;

import iskallia.vault.skill.ability.config.sub.DashDamageConfig;
import iskallia.vault.skill.ability.effect.DashAbility;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.AbilityTickResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class DashDamageAbility
extends DashAbility<DashDamageConfig> {
    private static final double DAMAGE_RANGE = 2.0;
    private static final int DAMAGE_DURATION_TICKS = 20;
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(2.0).m_26888_(entity -> !(entity instanceof Player));
    private static final Map<UUID, PlayerDashDamageData> PLAYER_DATA_MAP = new HashMap<UUID, PlayerDashDamageData>();

    @Override
    protected AbilityActionResult doAction(DashDamageConfig config, ServerPlayer player, boolean active) {
        super.doAction(config, player, active);
        PLAYER_DATA_MAP.put(player.m_142081_(), new PlayerDashDamageData(20));
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    public AbilityTickResult onTick(DashDamageConfig config, ServerPlayer player, boolean active) {
        UUID playerUUID = player.m_142081_();
        PlayerDashDamageData data = PLAYER_DATA_MAP.get(playerUUID);
        if (data == null) {
            return AbilityTickResult.PASS;
        }
        List nearbyEntities = player.f_19853_.m_45971_(LivingEntity.class, TARGETING_CONDITIONS, (LivingEntity)player, player.m_142469_().m_82400_(4.0));
        for (LivingEntity nearbyEntity : nearbyEntities) {
            UUID nearbyEntityUUID = nearbyEntity.m_142081_();
            if (data.hitEntityIdSet.contains(nearbyEntityUUID)) continue;
            float playerAttackDamage = (float)player.m_21133_(Attributes.f_22281_);
            float playerDashDamage = playerAttackDamage * config.getAttackDamagePercentPerDash();
            nearbyEntity.m_6469_(DamageSource.m_19344_((Player)player), playerDashDamage);
            data.hitEntityIdSet.add(nearbyEntityUUID);
        }
        --data.durationTicks;
        if (data.durationTicks <= 0) {
            PLAYER_DATA_MAP.remove(playerUUID);
        }
        return AbilityTickResult.PASS;
    }

    private static class PlayerDashDamageData {
        private final Set<UUID> hitEntityIdSet = new HashSet<UUID>();
        private int durationTicks;

        private PlayerDashDamageData(int durationTicks) {
            this.durationTicks = durationTicks;
        }
    }
}

