/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.config.VeinMinerConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbstractHoldAbility;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class AbstractVeinMinerAbility<C extends VeinMinerConfig>
extends AbstractHoldAbility<C> {
    private static final List<IItemDamageHandler> DAMAGE_HANDLER_LIST = new ArrayList<IItemDamageHandler>(){};

    private static IItemDamageHandler getDamageHandler(ItemStack itemStack) {
        for (IItemDamageHandler handler : DAMAGE_HANDLER_LIST) {
            if (!handler.matches(itemStack)) continue;
            return handler;
        }
        return DefaultItemDamageHandler.INSTANCE;
    }

    @Override
    public String getAbilityGroupName() {
        return "Vein Miner";
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockMined(BlockEvent.BreakEvent event) {
        ServerPlayer player;
        Player player2;
        block6: {
            block5: {
                if (event.getWorld().m_5776_() || event.getPlayer() instanceof FakePlayer || !((player2 = event.getPlayer()) instanceof ServerPlayer)) break block5;
                player = (ServerPlayer)player2;
                player2 = event.getWorld();
                if (player2 instanceof ServerLevel) break block6;
            }
            return;
        }
        ServerLevel level = (ServerLevel)player2;
        if (this.isItemDenied(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return;
        }
        AbilityTree abilityTree = PlayerAbilitiesData.get(level).getAbilities((Player)player);
        AbilityNode<?, ?> node = abilityTree.getSelectedAbility();
        if (node == null || node.getAbility() != this || !abilityTree.isAbilityActive(node)) {
            return;
        }
        ActiveFlags.IS_AOE_MINING.runIfNotSet(() -> {
            BlockState blockState;
            BlockPos pos;
            VeinMinerConfig config = (VeinMinerConfig)node.getAbilityConfig();
            if (this.areaDig(config, level, player, pos = event.getPos(), (blockState = level.m_8055_(pos)).m_60734_())) {
                event.setCanceled(true);
            }
            abilityTree.setSwappingLocked(true);
        });
    }

    private boolean isItemDenied(ItemStack itemStack) {
        return ModConfigs.ABILITIES_VEIN_MINER_DENY_CONFIG.isItemDenied(itemStack);
    }

    private boolean areaDig(C config, ServerLevel level, ServerPlayer player, BlockPos pos, Block targetBlock) {
        int usesLeft;
        if (targetBlock == Blocks.f_50016_) {
            return false;
        }
        if (!level.m_8055_(pos).canHarvestBlock((BlockGetter)level, pos, (Player)player)) {
            return false;
        }
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        boolean heldItemStartedEmpty = heldItem.m_41619_();
        if (heldItem.m_41763_() && (usesLeft = heldItem.m_41776_() - heldItem.m_41773_()) <= 1) {
            return false;
        }
        IItemDamageHandler damageHandler = AbstractVeinMinerAbility.getDamageHandler(heldItem);
        int limit = ((VeinMinerConfig)config).getBlockLimit();
        HashSet<BlockPos> traversedBlocks = new HashSet<BlockPos>();
        LinkedList<BlockPos> positionQueue = new LinkedList<BlockPos>();
        positionQueue.add(pos);
        block0: while (!positionQueue.isEmpty()) {
            BlockPos headPos = (BlockPos)positionQueue.poll();
            for (BlockPos offset : BlockPos.m_121985_((BlockPos)headPos, (int)1, (int)1, (int)1).map(BlockPos::m_7949_).toList()) {
                BlockState blockState;
                if (traversedBlocks.size() >= limit) {
                    positionQueue.clear();
                    continue block0;
                }
                if (traversedBlocks.contains(offset) || (blockState = level.m_8055_(offset)).m_60795_() || blockState.m_60734_() != targetBlock) continue;
                this.destroyBlock(config, level, player, heldItem, damageHandler, offset, this.shouldVoid(level, player, blockState));
                if (heldItem.m_41619_() && !heldItemStartedEmpty) {
                    positionQueue.clear();
                    continue block0;
                }
                positionQueue.add(offset);
                traversedBlocks.add(offset);
            }
        }
        return true;
    }

    private void destroyBlock(C config, ServerLevel level, ServerPlayer player, ItemStack mainHandItem, IItemDamageHandler damageHandler, BlockPos pos, boolean shouldVoid) {
        GameType gameModeForPlayer = player.f_8941_.m_9290_();
        BlockState blockstate = level.m_8055_(pos);
        int experience = ForgeHooks.onBlockBreakEvent((Level)level, (GameType)gameModeForPlayer, (ServerPlayer)player, (BlockPos)pos);
        if (experience == -1) {
            return;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        Block block = blockstate.m_60734_();
        if (block instanceof GameMasterBlock && !player.m_36337_()) {
            level.m_7260_(pos, blockstate, blockstate, 3);
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockstate));
        } else if (!mainHandItem.onBlockStartBreak(pos, (Player)player) && !player.m_36187_((Level)level, pos, gameModeForPlayer)) {
            boolean canHarvestBlock;
            if (player.f_8941_.m_9295_()) {
                this.removeBlock(level, player, pos, false);
                return;
            }
            ItemStack mainHandItemProxy = this.getVeinMiningItemProxy((Player)player, config);
            mainHandItemProxy.m_41686_((Level)level, blockstate, pos, (Player)player);
            if (mainHandItemProxy.m_41619_() && !mainHandItem.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)mainHandItem, (InteractionHand)InteractionHand.MAIN_HAND);
                mainHandItem.m_41774_(1);
            } else if (damageHandler.wasDamaged(mainHandItem, mainHandItemProxy)) {
                damageHandler.applyDamage(mainHandItem, mainHandItemProxy);
            }
            boolean bl = canHarvestBlock = blockstate.canHarvestBlock((BlockGetter)level, pos, (Player)player) && !shouldVoid;
            if (this.removeBlock(level, player, pos, canHarvestBlock)) {
                if (canHarvestBlock) {
                    block.m_6240_((Level)level, (Player)player, pos, blockstate, blockentity, mainHandItemProxy);
                }
                if (experience > 0) {
                    block.m_49805_(level, pos, experience);
                }
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)blockstate));
            }
        }
    }

    private boolean removeBlock(ServerLevel level, ServerPlayer player, BlockPos pos, boolean canHarvest) {
        BlockState blockState = level.m_8055_(pos);
        boolean removed = blockState.onDestroyedByPlayer((Level)level, pos, (Player)player, canHarvest, level.m_6425_(pos));
        if (removed) {
            blockState.m_60734_().m_6786_((LevelAccessor)level, pos, blockState);
        }
        return removed;
    }

    protected abstract ItemStack getVeinMiningItemProxy(Player var1, C var2);

    protected abstract boolean shouldVoid(ServerLevel var1, ServerPlayer var2, BlockState var3);

    private static interface IItemDamageHandler {
        public boolean matches(ItemStack var1);

        public boolean wasDamaged(ItemStack var1, ItemStack var2);

        public void applyDamage(ItemStack var1, ItemStack var2);
    }

    private static class DefaultItemDamageHandler
    implements IItemDamageHandler {
        public static final IItemDamageHandler INSTANCE = new DefaultItemDamageHandler();

        private DefaultItemDamageHandler() {
        }

        @Override
        public boolean matches(ItemStack itemStack) {
            return true;
        }

        @Override
        public boolean wasDamaged(ItemStack itemStack, ItemStack proxy) {
            return itemStack.m_41773_() != proxy.m_41773_();
        }

        @Override
        public void applyDamage(ItemStack itemStack, ItemStack proxy) {
            itemStack.m_41721_(proxy.m_41773_());
        }
    }
}

