/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import iskallia.vault.init.ModParticles;
import iskallia.vault.skill.ability.config.HunterConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.AbstractInstantManaAbility;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.world.data.ServerVaults;
import java.awt.Color;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractHunterAbility<C extends HunterConfig>
extends AbstractInstantManaAbility<C> {
    @Override
    public String getAbilityGroupName() {
        return "Hunter";
    }

    @Override
    protected boolean canDoAction(C config, ServerPlayer player, boolean active) {
        return super.canDoAction(config, player, active) && ServerVaults.isInVault((Entity)player);
    }

    @Override
    protected AbilityActionResult doAction(C config, ServerPlayer player, boolean active) {
        Level world = player.m_20193_();
        if (!(world instanceof ServerLevel)) {
            return AbilityActionResult.FAIL;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        for (int delay = 0; delay < ((HunterConfig)config).getDurationTicks() / 5; ++delay) {
            ServerScheduler.INSTANCE.schedule(delay * 5, () -> this.selectPositions(config, serverWorld, player).forEach(highlightPosition -> {
                Color color = highlightPosition.color;
                for (int i = 0; i < 8; ++i) {
                    Vec3 v = MiscUtils.getRandomOffset(highlightPosition.blockPos, RANDOM);
                    serverWorld.m_8624_(player, (ParticleOptions)((SimpleParticleType)ModParticles.DEPTH_FIREWORK.get()), true, v.f_82479_, v.f_82480_, v.f_82481_, 0, (double)((float)color.getRed() / 255.0f), (double)((float)color.getGreen() / 255.0f), (double)((float)color.getBlue() / 255.0f), 1.0);
                }
            }));
        }
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    protected void doParticles(C config, ServerPlayer player) {
    }

    @Override
    protected void doSound(C config, ServerPlayer player) {
    }

    protected abstract List<HighlightPosition> selectPositions(C var1, ServerLevel var2, ServerPlayer var3);

    protected void forEachTileEntity(C config, Level world, Player player, BiConsumer<BlockPos, BlockEntity> consumer) {
        BlockPos playerOffset = player.m_142538_();
        double radius = ((HunterConfig)config).getSearchRadius();
        double radiusSq = radius * radius;
        int iRadius = Mth.m_14165_((double)radius);
        Vec3i radVec = new Vec3i(iRadius, iRadius, iRadius);
        ChunkPos posMin = new ChunkPos(player.m_142538_().m_141950_(radVec));
        ChunkPos posMax = new ChunkPos(player.m_142538_().m_141952_(radVec));
        for (int xx = posMin.f_45578_; xx <= posMax.f_45578_; ++xx) {
            for (int zz = posMin.f_45579_; zz <= posMax.f_45579_; ++zz) {
                LevelChunk ch = world.m_7726_().m_7131_(xx, zz);
                if (ch == null) continue;
                ch.m_62954_().forEach((pos, tile) -> {
                    if (tile != null && pos.m_123331_((Vec3i)playerOffset) <= radiusSq) {
                        consumer.accept((BlockPos)pos, (BlockEntity)tile);
                    }
                });
            }
        }
    }

    public record HighlightPosition(BlockPos blockPos, Color color) {
    }
}

