/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect.spi;

import iskallia.vault.skill.ability.config.FarmerConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbilityTickResult;
import iskallia.vault.skill.ability.effect.spi.core.AbstractHoldManaAbility;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractFarmerAbility<C extends FarmerConfig>
extends AbstractHoldManaAbility<C> {
    protected final Object2IntMap<UUID> tickCounterMap = new Object2IntOpenHashMap();

    protected AbstractFarmerAbility() {
        this.tickCounterMap.defaultReturnValue(0);
    }

    @Override
    public String getAbilityGroupName() {
        return "Farmer";
    }

    @Override
    protected AbilityTickResult doActiveTick(C config, ServerPlayer player) {
        int tickDelay = this.tickCounterMap.computeIfAbsent((Object)player.m_142081_(), uuid -> config.getTickDelay());
        if (tickDelay > 0) {
            this.tickCounterMap.put((Object)player.m_142081_(), tickDelay - 1);
            return super.doActiveTick(config, player);
        }
        this.tickCounterMap.removeInt((Object)player.m_142081_());
        this.doGrow(config, player, (ServerLevel)player.m_20193_());
        return super.doActiveTick(config, player);
    }

    protected void doGrow(C config, ServerPlayer player, ServerLevel world) {
        BlockPos playerPos = player.m_142538_();
        int horizontalRange = ((FarmerConfig)config).getHorizontalRange();
        int verticalRange = ((FarmerConfig)config).getVerticalRange();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        ArrayList<BlockPos> candidateList = new ArrayList<BlockPos>();
        for (int x = -horizontalRange; x <= horizontalRange; ++x) {
            for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                for (int y = -verticalRange; y <= verticalRange; ++y) {
                    mutableBlockPos.m_122178_(playerPos.m_123341_() + x, playerPos.m_123342_() + y, playerPos.m_123343_() + z);
                    BlockState blockState = world.m_8055_((BlockPos)mutableBlockPos);
                    Block block = blockState.m_60734_();
                    if (!this.canGrowBlock(world, (BlockPos)mutableBlockPos, block, blockState)) continue;
                    candidateList.add(new BlockPos((Vec3i)mutableBlockPos));
                }
            }
        }
        if (!candidateList.isEmpty()) {
            BlockPos pos = (BlockPos)candidateList.get(RANDOM.nextInt(candidateList.size()));
            BlockState state = world.m_8055_(pos);
            Block block = world.m_8055_(pos).m_60734_();
            this.doGrowBlock(config, player, world, pos, block, state);
        }
    }

    protected abstract boolean canGrowBlock(ServerLevel var1, BlockPos var2, Block var3, BlockState var4);

    protected abstract void doGrowBlock(C var1, ServerPlayer var2, ServerLevel var3, BlockPos var4, Block var5, BlockState var6);
}

