/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.PlayerStatEvent;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.config.TankConfig;
import iskallia.vault.skill.ability.effect.spi.AbstractTankAbility;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.AbilityTickResult;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbilityEffect;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.world.data.PlayerAbilitiesData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TankAbility
extends AbstractTankAbility<TankConfig> {
    public TankAbility() {
        ((PlayerStatEvent)CommonEvents.PLAYER_STAT.of(PlayerStat.RESISTANCE).filter(data -> data.getEntity().m_21023_(ModEffects.TANK_RESISTANCE))).register(this, data -> {
            int amplifier = data.getEntity().m_21124_(ModEffects.TANK_RESISTANCE).m_19564_();
            float resistance = (float)(amplifier + 1) / 100.0f;
            data.setValue(data.getValue() + resistance);
        });
    }

    @Override
    protected AbilityActionResult doToggle(TankConfig config, ServerPlayer player, boolean active) {
        if (active) {
            ModEffects.TANK.addTo((LivingEntity)player, 0);
            return AbilityActionResult.SUCCESS_COOLDOWN_DEFERRED;
        }
        player.m_21195_((MobEffect)ModEffects.TANK);
        player.m_21195_(ModEffects.TANK_RESISTANCE);
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    protected void doToggleSound(TankConfig config, ServerPlayer player, boolean active) {
        if (active) {
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.TANK, SoundSource.MASTER, 0.7f, 1.0f);
            player.m_6330_(ModSounds.TANK, SoundSource.MASTER, 0.7f, 1.0f);
        }
    }

    @Override
    protected AbilityTickResult doInactiveTick(TankConfig config, ServerPlayer player) {
        if (player.m_21023_((MobEffect)ModEffects.TANK)) {
            player.m_21195_((MobEffect)ModEffects.TANK);
        }
        if (player.m_21023_(ModEffects.TANK_RESISTANCE)) {
            player.m_21195_(ModEffects.TANK_RESISTANCE);
        }
        return AbilityTickResult.PASS;
    }

    @Override
    protected void doManaDepleted(TankConfig config, ServerPlayer player) {
        player.m_21195_((MobEffect)ModEffects.TANK);
        player.m_21195_(ModEffects.TANK_RESISTANCE);
    }

    @SubscribeEvent
    public void on(LivingDamageEvent event) {
        Object obj;
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).m_21023_((MobEffect)ModEffects.TANK) && event.getSource().m_7639_() instanceof LivingEntity)) {
            return;
        }
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        AbilityNode<?, ?> node = abilities.getNodeByName("Tank");
        if (node.getAbility() != this || !node.isLearned() || !((obj = node.getAbilityConfig()) instanceof TankConfig)) {
            return;
        }
        TankConfig config = (TankConfig)obj;
        MobEffectInstance resistanceEffectInstance = player.m_21124_(ModEffects.TANK_RESISTANCE);
        int existingAmplifier = resistanceEffectInstance == null ? 0 : resistanceEffectInstance.m_19564_();
        int newAmplifier = (int)((float)existingAmplifier + Math.max(config.getResistancePercentAddedPerHit() * 100.0f, 1.0f));
        int clampedAmplifier = Math.min(newAmplifier, (int)(config.getResistancePercentCap() * 100.0f));
        player.m_21195_(ModEffects.TANK_RESISTANCE);
        player.m_7292_(new MobEffectInstance(ModEffects.TANK_RESISTANCE, config.getDurationTicksPerHit(), clampedAmplifier, false, false, true));
        float pitch = 1.0f + (RANDOM.nextFloat() * 0.5f - 0.5f);
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.TANK_HIT, SoundSource.MASTER, 0.7f, pitch);
        player.m_6330_(ModSounds.TANK_HIT, SoundSource.MASTER, 0.7f, pitch);
    }

    public static class TankResistanceEffect
    extends MobEffect {
        public TankResistanceEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(resourceLocation);
        }
    }

    public static class TankEffect
    extends ToggleAbilityEffect {
        public TankEffect(int color, ResourceLocation resourceLocation) {
            super("Tank", color, resourceLocation);
        }
    }
}

