/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.eternal.ActiveEternalData;
import iskallia.vault.entity.eternal.EternalData;
import iskallia.vault.entity.eternal.EternalHelper;
import iskallia.vault.skill.ability.config.SummonEternalConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.AbstractInstantManaAbility;
import iskallia.vault.skill.archetype.archetype.CommanderArchetype;
import iskallia.vault.world.data.EternalsData;
import iskallia.vault.world.data.PlayerArchetypeData;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SummonEternalAbility<C extends SummonEternalConfig>
extends AbstractInstantManaAbility<C> {
    @Override
    public String getAbilityGroupName() {
        return "Summon Eternal";
    }

    @Override
    protected boolean canDoAction(C config, ServerPlayer player, boolean active) {
        Level level;
        if (player.m_20193_().m_5776_() || !((level = player.m_20193_()) instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        EternalsData.EternalGroup playerEternals = EternalsData.get(serverLevel).getEternals((Player)player);
        if (playerEternals.getEternals().isEmpty()) {
            player.m_6352_((Component)new TextComponent("You have no eternals to summon.").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return false;
        }
        if (!ServerVaults.isInVault((Entity)player) && ((SummonEternalConfig)config).isVaultOnly()) {
            player.m_6352_((Component)new TextComponent("You can only summon eternals in the Vault!").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return false;
        }
        return super.canDoAction(config, player, active);
    }

    @Override
    protected AbilityActionResult doAction(C config, ServerPlayer player, boolean active) {
        Level level = player.m_20193_();
        if (!(level instanceof ServerLevel)) {
            return AbilityActionResult.FAIL;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        EternalsData.EternalGroup playerEternals = EternalsData.get(serverLevel).getEternals((Player)player);
        ArrayList<EternalData> eternals = new ArrayList<EternalData>();
        int count = ((SummonEternalConfig)config).getNumberOfEternals();
        for (int i = 0; i < count; ++i) {
            EternalData eternal = null;
            if (RANDOM.nextFloat() < ((SummonEternalConfig)config).getAncientChance()) {
                eternal = playerEternals.getRandomAliveAncient(RANDOM, eternalData -> !eternals.contains(eternalData) && !ActiveEternalData.getInstance().isEternalActive(eternalData.getId()));
            }
            if (eternal == null) {
                eternal = playerEternals.getRandomAlive(RANDOM, eternalData -> !eternals.contains(eternalData) && !ActiveEternalData.getInstance().isEternalActive(eternalData.getId()));
            }
            if (eternal == null) continue;
            eternals.add(eternal);
        }
        if (eternals.isEmpty()) {
            player.m_6352_((Component)new TextComponent("You have no (alive) eternals to summon.").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return AbilityActionResult.FAIL;
        }
        for (EternalData eternalData2 : eternals) {
            EternalEntity eternal = EternalHelper.spawnEternal((Level)serverLevel, eternalData2);
            eternal.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
            eternal.setDespawnTime(serverLevel.m_142572_().m_129921_() + ((SummonEternalConfig)config).getDespawnTime());
            eternal.setOwner(player.m_142081_());
            eternal.setEternalId(eternalData2.getId());
            eternal.m_7292_(new MobEffectInstance(MobEffects.f_19619_, Integer.MAX_VALUE, 0, true, false));
            PlayerArchetypeData.get(serverLevel).getArchetypeContainer((Player)player).ifCurrentArchetype(CommanderArchetype.class, archetype -> archetype.applyToEternal(eternal));
            if (eternalData2.getAura() != null) {
                eternal.setProvidedAura(eternalData2.getAura().getAuraName());
            }
            serverLevel.m_7967_((Entity)eternal);
        }
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    protected void doParticles(C config, ServerPlayer player) {
    }

    @Override
    protected void doSound(C config, ServerPlayer player) {
    }

    @SubscribeEvent
    public void onDamage(LivingAttackEvent event) {
        Player player;
        LivingEntity damagedEntity = event.getEntityLiving();
        Entity dealerEntity = event.getSource().m_7639_();
        if (damagedEntity instanceof EternalEntity && dealerEntity instanceof Player && !(player = (Player)dealerEntity).m_7500_()) {
            event.setCanceled(true);
        }
    }
}

