/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import iskallia.vault.init.ModEffects;
import iskallia.vault.skill.ability.config.StonefallConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.AbstractInstantManaAbility;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StonefallAbility<C extends StonefallConfig>
extends AbstractInstantManaAbility<C> {
    @Override
    public String getAbilityGroupName() {
        return "Stonefall";
    }

    @Override
    protected boolean canDoAction(C config, ServerPlayer player, boolean active) {
        return !player.m_21023_(ModEffects.STONEFALL) && super.canDoAction(config, player, active);
    }

    @Override
    protected AbilityActionResult doAction(C config, ServerPlayer player, boolean active) {
        player.m_7292_(new MobEffectInstance(ModEffects.STONEFALL, ((StonefallConfig)config).getDurationTicks(), 0, false, false, true));
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @SubscribeEvent
    public void on(LivingAttackEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        MobEffectInstance effectInstance = serverPlayer.m_21124_(ModEffects.STONEFALL);
        if (effectInstance == null) {
            return;
        }
        if (event.getSource() == DamageSource.f_19315_) {
            event.setCanceled(true);
        }
    }

    public static class StonefallEffect
    extends MobEffect {
        public StonefallEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(resourceLocation);
        }
    }
}

