/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import iskallia.vault.event.ActiveFlags;
import iskallia.vault.skill.ability.config.NovaConfig;
import iskallia.vault.skill.ability.effect.spi.AbstractNovaAbility;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import java.awt.Color;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potions;

public class NovaAbility<C extends NovaConfig>
extends AbstractNovaAbility<C> {
    @Override
    protected AbilityActionResult doAction(C config, ServerPlayer player, boolean active) {
        List<LivingEntity> targetEntities = this.getTargetEntities(config, player);
        float attackDamage = this.getAttackDamage(config, player);
        DamageSource damageSource = DamageSource.m_19344_((Player)player);
        for (LivingEntity entity : targetEntities) {
            ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
                if (entity.m_6469_(damageSource, attackDamage) && !Mth.m_14033_((float)config.getKnockbackStrengthMultiplier(), (float)0.0f)) {
                    double dz;
                    double dx = player.m_20185_() - entity.m_20185_();
                    if (dx * dx + (dz = player.m_20189_() - entity.m_20189_()) * dz < 1.0E-4) {
                        dx = (Math.random() - Math.random()) * 0.01;
                        dz = (Math.random() - Math.random()) * 0.01;
                    }
                    entity.m_147240_((double)(0.4f * config.getKnockbackStrengthMultiplier()), dx, dz);
                }
            });
        }
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    protected void doParticles(C config, ServerPlayer player) {
        super.doParticles(config, player);
        int particleCount = (int)Mth.m_14008_((double)(Math.pow(((NovaConfig)config).getRadius(), 2.0) * 3.1415927410125732 * 100.0), (double)50.0, (double)400.0);
        ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123813_, player.m_20185_(), player.m_20186_(), player.m_20189_(), particleCount, (double)((NovaConfig)config).getRadius() * 0.5, 0.5, (double)((NovaConfig)config).getRadius() * 0.5, 0.0);
        ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20186_(), player.m_20189_(), particleCount / 2, (double)((NovaConfig)config).getRadius() * 0.5, 0.5, (double)((NovaConfig)config).getRadius() * 0.5, 0.0);
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_());
        areaEffectCloud.m_19718_((LivingEntity)player);
        areaEffectCloud.m_19712_(((NovaConfig)config).getRadius());
        areaEffectCloud.m_19732_(-0.5f);
        areaEffectCloud.m_19740_(0);
        areaEffectCloud.m_19734_(4);
        areaEffectCloud.m_19722_(Potions.f_43598_);
        areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
        areaEffectCloud.m_19714_(Color.RED.getRGB());
        areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123744_);
        player.f_19853_.m_7967_((Entity)areaEffectCloud);
    }

    @Override
    protected void doSound(C config, ServerPlayer player) {
        player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 0.2f, 1.0f);
        player.m_6330_(SoundEvents.f_11913_, SoundSource.PLAYERS, 0.2f, 1.0f);
    }
}

