/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.mana.Mana;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.config.ManaShieldConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.AbilityTickResult;
import iskallia.vault.skill.ability.effect.spi.core.AbstractToggleManaAbility;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbilityEffect;
import iskallia.vault.world.data.PlayerAbilitiesData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ManaShieldAbility<C extends ManaShieldConfig>
extends AbstractToggleManaAbility<C> {
    @Override
    public String getAbilityGroupName() {
        return "Mana Shield";
    }

    @Override
    protected AbilityActionResult doToggle(C config, ServerPlayer player, boolean active) {
        if (active) {
            ModEffects.MANA_SHIELD.addTo((LivingEntity)player, 0);
            return AbilityActionResult.SUCCESS_COOLDOWN_DEFERRED;
        }
        player.m_21195_((MobEffect)ModEffects.MANA_SHIELD);
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    protected void doToggleSound(C config, ServerPlayer player, boolean active) {
        if (active) {
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.MANA_SHIELD, SoundSource.MASTER, 0.4f, 1.0f);
            player.m_6330_(ModSounds.MANA_SHIELD, SoundSource.MASTER, 0.4f, 1.0f);
        }
    }

    @Override
    protected AbilityTickResult doInactiveTick(C config, ServerPlayer player) {
        if (player.m_21023_((MobEffect)ModEffects.MANA_SHIELD)) {
            player.m_21195_((MobEffect)ModEffects.MANA_SHIELD);
        }
        return AbilityTickResult.PASS;
    }

    @Override
    protected void doManaDepleted(C config, ServerPlayer player) {
        player.m_21195_((MobEffect)ModEffects.MANA_SHIELD);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void on(LivingHurtEvent event) {
        Object obj;
        ServerPlayer player;
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer) || !(player = (ServerPlayer)entity).m_21023_((MobEffect)ModEffects.MANA_SHIELD)) {
            return;
        }
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        AbilityNode<?, ?> node = abilities.getNodeOf(this);
        if (node.getAbility() != this || !node.isLearned() || !((obj = node.getAbilityConfig()) instanceof ManaShieldConfig)) {
            return;
        }
        ManaShieldConfig config = (ManaShieldConfig)obj;
        float percentageDamageAbsorbed = Mth.m_14036_((float)config.getPercentageDamageAbsorbed(), (float)0.0f, (float)1.0f);
        float redirectedDamage = Math.min(event.getAmount() * percentageDamageAbsorbed, Mana.get((Player)player));
        if (Mth.m_14033_((float)redirectedDamage, (float)0.0f)) {
            return;
        }
        if (Mth.m_14033_((float)redirectedDamage, (float)event.getAmount())) {
            event.setCanceled(true);
        } else {
            event.setAmount(event.getAmount() - redirectedDamage);
        }
        float mana = Mana.decrease((Player)player, redirectedDamage);
        float pitch = 1.25f + -0.5f * (mana / Mana.getMax((Player)player));
        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.MANA_SHIELD_HIT, SoundSource.MASTER, 0.2f, pitch);
        player.m_6330_(ModSounds.MANA_SHIELD_HIT, SoundSource.MASTER, 0.2f, pitch);
    }

    public static class ManaShieldEffect
    extends ToggleAbilityEffect {
        public ManaShieldEffect(int color, ResourceLocation resourceLocation) {
            super("Mana Shield", color, resourceLocation);
        }
    }
}

