/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.config.GhostWalkConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.AbstractInstantManaAbility;
import iskallia.vault.util.damage.PlayerDamageHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GhostWalkAbility<C extends GhostWalkConfig>
extends AbstractInstantManaAbility<C> {
    @Override
    public String getAbilityGroupName() {
        return "Ghost Walk";
    }

    @Override
    protected AbilityActionResult doAction(C config, ServerPlayer player, boolean active) {
        if (player.m_21023_(ModEffects.GHOST_WALK)) {
            return AbilityActionResult.FAIL;
        }
        MobEffectInstance newEffect = new MobEffectInstance(ModEffects.GHOST_WALK, ((GhostWalkConfig)config).getDurationTicks(), 0, false, false, true);
        player.m_7292_(newEffect);
        return AbilityActionResult.SUCCESS_COOLDOWN_DEFERRED;
    }

    @Override
    protected void doSound(C config, ServerPlayer player) {
        player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.GHOST_WALK_SFX, SoundSource.PLAYERS, 0.2f, 1.0f);
        player.m_6330_(ModSounds.GHOST_WALK_SFX, SoundSource.PLAYERS, 0.2f, 1.0f);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDamage(LivingDamageEvent event) {
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof ServerPlayer) {
            ServerLevel world;
            PlayerAbilitiesData data;
            AbilityTree abilities;
            AbilityNode<?, ?> node;
            MobEffectInstance ghostWalk;
            ServerPlayer serverPlayer = (ServerPlayer)attacker;
            if (this.doRemoveWhenDealingDamage() && (ghostWalk = serverPlayer.m_21124_(ModEffects.GHOST_WALK)) != null && (node = (abilities = (data = PlayerAbilitiesData.get(world = (ServerLevel)serverPlayer.m_20193_())).getAbilities((Player)serverPlayer)).getNodeOf(this)).getAbility() == this && node.isLearned()) {
                serverPlayer.m_21195_(ModEffects.GHOST_WALK);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onHurt(LivingHurtEvent event) {
        if (this.isInvulnerable(event.getEntityLiving(), event.getSource())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onAttack(LivingAttackEvent event) {
        if (this.isInvulnerable(event.getEntityLiving(), event.getSource())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof Mob && this.isInvulnerable(event.getTarget(), null)) {
            ((Mob)event.getEntityLiving()).m_6710_(null);
        }
    }

    private boolean isInvulnerable(@Nullable LivingEntity entity, @Nullable DamageSource source) {
        ServerPlayer serverPlayer;
        MobEffectInstance ghostWalk;
        if (entity instanceof ServerPlayer && (ghostWalk = (serverPlayer = (ServerPlayer)entity).m_21124_(ModEffects.GHOST_WALK)) != null && this.preventsDamage() && (source == null || !source.m_19378_())) {
            ServerLevel world = (ServerLevel)serverPlayer.m_20193_();
            PlayerAbilitiesData data = PlayerAbilitiesData.get(world);
            AbilityTree abilities = data.getAbilities((Player)serverPlayer);
            AbilityNode<?, ?> node = abilities.getNodeOf(this);
            return node.getAbility() == this && node.isLearned();
        }
        return false;
    }

    protected boolean preventsDamage() {
        return true;
    }

    protected boolean doRemoveWhenDealingDamage() {
        return true;
    }

    public static class GhostWalkEffect
    extends MobEffect {
        private static final UUID DAMAGE_MULTIPLIER_ID = UUID.fromString("d0476bd8-d306-4a40-9229-a0933b830617");

        public GhostWalkEffect(MobEffectCategory typeIn, int liquidColorIn, ResourceLocation id) {
            super(typeIn, liquidColorIn);
            this.setRegistryName(id);
        }

        public boolean m_6584_(int duration, int amplifier) {
            return true;
        }

        @ParametersAreNonnullByDefault
        public void m_6385_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                this.removeExistingDamageBuff(player);
            }
            super.m_6385_(livingEntity, attributeMap, amplifier);
        }

        @ParametersAreNonnullByDefault
        public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                this.removeExistingDamageBuff(player);
                PlayerAbilitiesData.setAbilityOnCooldown(player, "Ghost Walk");
            }
            super.m_6386_(livingEntity, attributeMap, amplifier);
        }

        private void removeExistingDamageBuff(ServerPlayer player) {
            PlayerDamageHelper.DamageMultiplier existing = PlayerDamageHelper.getMultiplier(player, DAMAGE_MULTIPLIER_ID);
            if (existing != null) {
                PlayerDamageHelper.removeMultiplier(player, existing);
            }
        }
    }
}

