/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import iskallia.vault.skill.ability.config.ExecuteConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.AbstractInstantAbility;
import iskallia.vault.world.data.PlayerAbilitiesData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ExecuteAbility<C extends ExecuteConfig>
extends AbstractInstantAbility<C> {
    @Override
    public String getAbilityGroupName() {
        return "Execute";
    }

    @Override
    protected AbilityActionResult doAction(C config, ServerPlayer player, boolean active) {
        if (player.m_21023_(ModEffects.EXECUTE)) {
            return AbilityActionResult.FAIL;
        }
        MobEffectInstance newEffect = new MobEffectInstance(ModEffects.EXECUTE, ((ExecuteConfig)config).getEffectDurationTicks(), 0, false, false, true);
        player.m_7292_(newEffect);
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    protected void doParticles(C config, ServerPlayer player) {
    }

    @Override
    protected void doSound(C config, ServerPlayer player) {
        player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.EXECUTION_SFX, SoundSource.PLAYERS, 0.4f, 1.0f);
        player.m_6330_(ModSounds.EXECUTION_SFX, SoundSource.PLAYERS, 0.4f, 1.0f);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void on(LivingDamageEvent event) {
        ServerPlayer serverPlayer;
        Entity entity;
        if (event.getEntity().m_20193_().m_5776_() || !((entity = event.getSource().m_7639_()) instanceof ServerPlayer) || !((entity = (serverPlayer = (ServerPlayer)entity).m_20193_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)entity;
        MobEffectInstance effectInstance = serverPlayer.m_21124_(ModEffects.EXECUTE);
        if (effectInstance == null) {
            return;
        }
        PlayerAbilitiesData data = PlayerAbilitiesData.get(serverLevel);
        AbilityTree abilities = data.getAbilities((Player)serverPlayer);
        AbilityNode<?, ?> node = abilities.getNodeByName("Execute");
        if (node.getAbility() != this || !node.isLearned()) {
            return;
        }
        ExecuteConfig config = (ExecuteConfig)node.getAbilityConfig();
        if (config == null) {
            return;
        }
        float maxHealth = event.getEntityLiving().m_21233_();
        float damageDealt = maxHealth * config.getDamageHealthPercentage();
        event.setAmount(event.getAmount() + damageDealt);
        serverPlayer.m_21195_(ModEffects.EXECUTE);
    }

    public static class ExecuteEffect
    extends MobEffect {
        public ExecuteEffect(MobEffectCategory type, int color, ResourceLocation id) {
            super(type, color);
            this.setRegistryName(id);
        }
    }
}

