/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.effect;

import iskallia.vault.easteregg.GrasshopperNinja;
import iskallia.vault.init.ModSounds;
import iskallia.vault.skill.ability.config.DashConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.AbstractInstantManaAbility;
import iskallia.vault.util.MathUtilities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class DashAbility<C extends DashConfig>
extends AbstractInstantManaAbility<C> {
    @Override
    public String getAbilityGroupName() {
        return "Dash";
    }

    @Override
    protected AbilityActionResult doAction(C config, ServerPlayer player, boolean active) {
        Vec3 lookVector = player.m_20154_();
        double magnitude = (double)(10 + ((DashConfig)config).getExtraDistance()) * 0.15;
        double extraPitch = 10.0;
        Vec3 dashVector = new Vec3(lookVector.m_7096_(), lookVector.m_7098_(), lookVector.m_7094_());
        float initialYaw = (float)MathUtilities.extractYaw(dashVector);
        double dashPitch = Math.toDegrees(MathUtilities.extractPitch(dashVector = MathUtilities.rotateYaw(dashVector, initialYaw)));
        if (dashPitch + extraPitch > 90.0) {
            dashVector = new Vec3(0.0, 1.0, 0.0);
            dashPitch = 90.0;
        } else {
            dashVector = MathUtilities.rotateRoll(dashVector, (float)Math.toRadians(-extraPitch));
            dashVector = MathUtilities.rotateYaw(dashVector, -initialYaw);
            dashVector = dashVector.m_82541_();
        }
        double coeff = 1.6 - MathUtilities.map(Math.abs(dashPitch), 0.0, 90.0, 0.6, 1.0);
        dashVector = dashVector.m_82490_(magnitude * coeff);
        player.m_5997_(dashVector.m_7096_(), dashVector.m_7098_(), dashVector.m_7094_());
        player.f_19864_ = true;
        return AbilityActionResult.SUCCESS_COOLDOWN;
    }

    @Override
    protected void doParticles(C config, ServerPlayer player) {
        ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 1.0, 0.5, 1.0, 0.0);
    }

    @Override
    protected void doSound(C config, ServerPlayer player) {
        if (GrasshopperNinja.isGrasshopperShape((Player)player)) {
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.GRASSHOPPER_BRRR, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.m_6330_(ModSounds.GRASSHOPPER_BRRR, SoundSource.PLAYERS, 0.2f, 1.0f);
            GrasshopperNinja.achieve(player);
        } else {
            player.f_19853_.m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.DASH_SFX, SoundSource.PLAYERS, 0.2f, 1.0f);
            player.m_6330_(ModSounds.DASH_SFX, SoundSource.PLAYERS, 0.2f, 1.0f);
        }
    }
}

