/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.component;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.ability.component.AbilityLabelBindingRegistry;
import iskallia.vault.skill.ability.component.AbilityLabelContext;
import iskallia.vault.skill.ability.config.spi.AbstractAbilityConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;

public final class AbilityLabelFactory {
    public static final String COOLDOWN = "cooldown";
    public static final String MANA_COST = "manaCost";
    public static final String MANA_COST_PER_SECOND = "manaCostPerSecond";
    public static final String LEVEL = "level";
    public static final String DISTANCE = "distance";
    public static final String DAMAGE = "damage";
    public static final String DURATION = "duration";
    public static final String DELAY = "delay";
    public static final String RANGE_HORIZONTAL = "rangeHorizontal";
    public static final String RANGE_VERTICAL = "rangeVertical";
    public static final String CHANCE = "chance";
    public static final String HEAL = "heal";
    public static final String RADIUS = "radius";
    public static final String ABSORB = "absorb";
    public static final String KNOCKBACK = "knockback";
    public static final String SLOWNESS = "slowness";
    public static final String CHAINS = "chains";
    public static final String LEECH = "leech";
    public static final String ETERNALS = "eternals";
    public static final String ANCIENT_CHANCE = "ancientChance";
    public static final String RESISTANCE = "resistance";
    public static final String RESISTANCE_KNOCKBACK = "resistanceKnockback";
    public static final String REDUCED_PROJECTILE_DAMAGE_TAKEN = "reducedProjectileDamageTaken";
    public static final String BLOCKS = "blocks";
    public static final String UNBREAKING = "unbreaking";
    public static final String FORTUNE = "fortune";
    private static final Map<String, IAbilityComponentFactory> FACTORY_MAP = new HashMap<String, IAbilityComponentFactory>(){
        {
            this.put(AbilityLabelFactory.COOLDOWN, context -> AbilityLabelFactory.label("\n Cooldown: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.COOLDOWN), AbilityLabelFactory.COOLDOWN));
            this.put(AbilityLabelFactory.MANA_COST, context -> AbilityLabelFactory.label("\n Mana Cost: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.MANA_COST), AbilityLabelFactory.MANA_COST));
            this.put(AbilityLabelFactory.MANA_COST_PER_SECOND, context -> AbilityLabelFactory.label("\n Mana / Sec: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.MANA_COST), AbilityLabelFactory.MANA_COST));
            this.put(AbilityLabelFactory.LEVEL, context -> {
                String levelString = AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.LEVEL);
                return AbilityLabelFactory.label("\n Min Level: ", levelString, context.vaultLevel() < Integer.parseInt(levelString) ? "levelLo" : "levelHi");
            });
            this.put(AbilityLabelFactory.DISTANCE, context -> AbilityLabelFactory.label("\n Distance: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.DISTANCE), AbilityLabelFactory.DISTANCE));
            this.put(AbilityLabelFactory.DAMAGE, context -> AbilityLabelFactory.label("\n Damage: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.DAMAGE), AbilityLabelFactory.DAMAGE));
            this.put(AbilityLabelFactory.DURATION, context -> AbilityLabelFactory.label("\n Duration: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.DURATION), AbilityLabelFactory.DURATION));
            this.put(AbilityLabelFactory.DELAY, context -> AbilityLabelFactory.label("\n Delay: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.DELAY), AbilityLabelFactory.DELAY));
            this.put(AbilityLabelFactory.RANGE_HORIZONTAL, context -> AbilityLabelFactory.label("\n XZ Range: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.RANGE_HORIZONTAL), "range"));
            this.put(AbilityLabelFactory.RANGE_VERTICAL, context -> AbilityLabelFactory.label("\n Y Range: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.RANGE_VERTICAL), "range"));
            this.put(AbilityLabelFactory.CHANCE, context -> AbilityLabelFactory.label("\n Chance: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.CHANCE), AbilityLabelFactory.CHANCE));
            this.put(AbilityLabelFactory.HEAL, context -> AbilityLabelFactory.label("\n Heal: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.HEAL), AbilityLabelFactory.HEAL));
            this.put(AbilityLabelFactory.RADIUS, context -> AbilityLabelFactory.label("\n Radius: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.RADIUS), AbilityLabelFactory.RADIUS));
            this.put(AbilityLabelFactory.ABSORB, context -> AbilityLabelFactory.label("\n Absorb: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.ABSORB), AbilityLabelFactory.ABSORB));
            this.put(AbilityLabelFactory.KNOCKBACK, context -> AbilityLabelFactory.label("\n Knockback: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.KNOCKBACK), AbilityLabelFactory.KNOCKBACK));
            this.put(AbilityLabelFactory.SLOWNESS, context -> AbilityLabelFactory.label("\n Slowness: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.SLOWNESS), AbilityLabelFactory.SLOWNESS));
            this.put(AbilityLabelFactory.CHAINS, context -> AbilityLabelFactory.label("\n Chains: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.CHAINS), AbilityLabelFactory.CHAINS));
            this.put(AbilityLabelFactory.LEECH, context -> AbilityLabelFactory.label("\n Leech: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.LEECH), AbilityLabelFactory.LEECH));
            this.put(AbilityLabelFactory.ETERNALS, context -> AbilityLabelFactory.label("\n Eternals: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.ETERNALS), AbilityLabelFactory.ETERNALS));
            this.put(AbilityLabelFactory.ANCIENT_CHANCE, context -> AbilityLabelFactory.label("\n Ancient Chance: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.CHANCE), AbilityLabelFactory.CHANCE));
            this.put(AbilityLabelFactory.RESISTANCE, context -> AbilityLabelFactory.label("\n Resistance: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.RESISTANCE), AbilityLabelFactory.RESISTANCE));
            this.put(AbilityLabelFactory.RESISTANCE_KNOCKBACK, context -> AbilityLabelFactory.label("\n Knockback Res.: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.RESISTANCE), AbilityLabelFactory.RESISTANCE));
            this.put(AbilityLabelFactory.REDUCED_PROJECTILE_DAMAGE_TAKEN, context -> AbilityLabelFactory.label("\n Projectile Resistance: ", AbilityLabelFactory.binding(context.config(), "projectileDamageTaken"), "projectileDamageTaken"));
            this.put(AbilityLabelFactory.BLOCKS, context -> AbilityLabelFactory.label("\n Blocks: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.BLOCKS), AbilityLabelFactory.BLOCKS));
            this.put(AbilityLabelFactory.UNBREAKING, context -> AbilityLabelFactory.label("\n Unbreaking: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.UNBREAKING), AbilityLabelFactory.UNBREAKING));
            this.put(AbilityLabelFactory.FORTUNE, context -> AbilityLabelFactory.label("\n Fortune: ", AbilityLabelFactory.binding(context.config(), AbilityLabelFactory.FORTUNE), AbilityLabelFactory.FORTUNE));
        }
    };

    public static MutableComponent create(String key, AbilityLabelContext<?> context) {
        IAbilityComponentFactory factory = FACTORY_MAP.get(key);
        if (factory == null) {
            return new TextComponent("\n MISSING: " + key);
        }
        return factory.create(context);
    }

    private static <C extends AbstractAbilityConfig> String binding(C config, String key) {
        return AbilityLabelBindingRegistry.getBindingValue(config, key);
    }

    private static MutableComponent label(String label, String value, String colorKey) {
        return new TextComponent(label).m_130948_(Style.f_131099_.m_131148_(ModConfigs.COLORS.getColor("text"))).m_7220_((Component)AbilityLabelFactory.text(value, colorKey));
    }

    private static MutableComponent text(String text, String colorKey) {
        return AbilityLabelFactory.text(text, ModConfigs.COLORS.getColor(colorKey));
    }

    private static MutableComponent text(String text, TextColor color) {
        return new TextComponent(text).m_130948_(Style.f_131099_.m_131148_(color));
    }

    private AbilityLabelFactory() {
    }

    public static interface IAbilityComponentFactory {
        public MutableComponent create(AbilityLabelContext<?> var1);
    }
}

