/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability.component;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.ability.component.AbilityLabelContext;
import iskallia.vault.skill.ability.component.AbilityLabelFactory;
import iskallia.vault.skill.ability.group.AbilityGroup;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public final class AbilityDescriptionFactory {
    public static MutableComponent create(AbilityGroup<?, ?> group, @Nullable String specialization, int abilityLevel, int vaultLevel) {
        List<String> keys;
        Object config;
        String skillName = specialization == null ? group.getParentName() : specialization;
        MutableComponent component = ModConfigs.ABILITIES_DESCRIPTIONS.getDescriptionFor(skillName);
        if (abilityLevel > 0) {
            config = group.getAbilityConfig(specialization, abilityLevel - 1);
            keys = ModConfigs.ABILITIES_DESCRIPTIONS.getCurrent(skillName);
            AbilityDescriptionFactory.appendLabels(component, keys, "\n\nCurrent", new AbilityLabelContext(config, vaultLevel));
        }
        if (abilityLevel < group.getMaxLevel()) {
            config = group.getAbilityConfig(specialization, abilityLevel);
            keys = ModConfigs.ABILITIES_DESCRIPTIONS.getNext(skillName);
            AbilityDescriptionFactory.appendLabels(component, keys, "\n\nNext", new AbilityLabelContext(config, vaultLevel));
        }
        return component;
    }

    private static void appendLabels(MutableComponent component, List<String> keys, String header, AbilityLabelContext<?> context) {
        if (!keys.isEmpty()) {
            component.m_7220_((Component)new TextComponent(header).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
            for (String key : keys) {
                component.m_7220_((Component)AbilityLabelFactory.create(key, context));
            }
        }
    }

    private AbilityDescriptionFactory() {
    }
}

