/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.ability;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.ability.KeyBehavior;
import iskallia.vault.skill.ability.config.spi.AbstractAbilityConfig;
import iskallia.vault.skill.ability.effect.spi.core.AbilityActionResult;
import iskallia.vault.skill.ability.effect.spi.core.AbilityTickResult;
import iskallia.vault.skill.ability.effect.spi.core.AbstractAbility;
import iskallia.vault.skill.ability.group.AbilityGroup;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;

public class AbilityNode<T extends AbstractAbilityConfig, E extends AbstractAbility<T>>
implements INBTSerializable<CompoundTag> {
    private String groupName;
    private int level = 0;
    private String specialization = null;
    private static final String TAG_NAME = "Name";
    public static final String TAG_LEVEL = "Level";
    public static final String TAG_SPECIALIZATION = "Specialization";

    public AbilityNode(String groupName, int level, @Nullable String specialization) {
        this.groupName = groupName;
        this.level = level;
        this.specialization = specialization;
    }

    private AbilityNode(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    public AbilityGroup<T, E> getGroup() {
        return ModConfigs.ABILITIES.getAbilityGroupByName(this.groupName);
    }

    public int getLevel() {
        return this.level;
    }

    @Nullable
    public String getSpecialization() {
        return this.specialization;
    }

    public void setSpecialization(@Nullable String specialization) {
        this.specialization = specialization;
    }

    public String getName() {
        if (!this.isLearned()) {
            return this.getGroup().getName(1);
        }
        return this.getGroup().getName(this.getLevel());
    }

    public String getSpecializationName() {
        String specialization = this.getSpecialization();
        if (specialization == null) {
            return this.getGroup().getParentName();
        }
        return this.getGroup().getSpecializationName(specialization);
    }

    public boolean isLearned() {
        return this.getLevel() > 0;
    }

    @Nullable
    public T getAbilityConfig() {
        if (!this.isLearned()) {
            return this.getGroup().getAbilityConfig(null, -1);
        }
        return this.getGroup().getAbilityConfig(this.getSpecialization(), this.getLevel() - 1);
    }

    @Nullable
    public E getAbility() {
        return this.getGroup().getAbility(this.getSpecialization());
    }

    public KeyBehavior getKeyBehavior() {
        return ((AbstractAbility)this.getAbility()).getKeyBehavior();
    }

    public void onAdded(Player player) {
        if (this.isLearned() && this.getAbility() != null) {
            ((AbstractAbility)this.getAbility()).onAdded(this.getAbilityConfig(), player);
        }
    }

    public void onRemoved(Player player) {
        if (this.isLearned() && this.getAbility() != null) {
            ((AbstractAbility)this.getAbility()).onRemoved(this.getAbilityConfig(), player);
        }
    }

    public void onFocus(Player player) {
        if (this.isLearned() && this.getAbility() != null) {
            ((AbstractAbility)this.getAbility()).onFocus(this.getAbilityConfig(), player);
        }
    }

    public void onBlur(Player player) {
        if (this.isLearned() && this.getAbility() != null) {
            ((AbstractAbility)this.getAbility()).onBlur(this.getAbilityConfig(), player);
        }
    }

    public AbilityTickResult onTick(ServerPlayer player, boolean active) {
        if (this.isLearned() && this.getAbility() != null) {
            return ((AbstractAbility)this.getAbility()).onTick(this.getAbilityConfig(), player, active);
        }
        return AbilityTickResult.PASS;
    }

    public AbilityActionResult onAction(ServerPlayer player, boolean active) {
        if (this.isLearned() && this.getAbility() != null) {
            return ((AbstractAbility)this.getAbility()).onAction(this.getAbilityConfig(), player, active);
        }
        return AbilityActionResult.FAIL;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(TAG_NAME, this.getGroup().getParentName());
        nbt.m_128405_(TAG_LEVEL, this.getLevel());
        if (this.getSpecialization() != null) {
            nbt.m_128359_(TAG_SPECIALIZATION, this.getSpecialization());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.groupName = nbt.m_128461_(TAG_NAME);
        this.level = nbt.m_128451_(TAG_LEVEL);
        this.specialization = nbt.m_128425_(TAG_SPECIALIZATION, 8) ? nbt.m_128461_(TAG_SPECIALIZATION) : null;
    }

    public static <T extends AbstractAbilityConfig, E extends AbstractAbility<T>> AbilityNode<T, E> fromNBT(CompoundTag nbt) {
        return new AbilityNode<T, E>(nbt);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbilityNode that = (AbilityNode)other;
        return this.level == that.level && Objects.equals(this.getGroup(), that.getGroup());
    }

    public int hashCode() {
        return Objects.hash(this.getGroup(), this.level);
    }
}

