/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill;

import com.google.gson.annotations.Expose;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.research.type.Research;
import iskallia.vault.skill.ability.group.AbilityGroup;
import iskallia.vault.skill.talent.TalentGroup;
import iskallia.vault.skill.talent.TalentTree;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SkillGates {
    @Expose
    private final Map<String, Entry> entries = new HashMap<String, Entry>();

    public void addEntry(String skillName, Entry entry) {
        this.entries.put(skillName, entry);
    }

    public List<AbilityGroup<?, ?>> getDependencyAbilities(String abilityName) {
        LinkedList abilities = new LinkedList();
        Entry entry = this.entries.get(abilityName);
        if (entry == null) {
            return abilities;
        }
        entry.dependsOn.forEach(dependencyName -> {
            AbilityGroup<?, ?> dependency = ModConfigs.ABILITIES.getAbilityGroupByName((String)dependencyName);
            abilities.add(dependency);
        });
        return abilities;
    }

    public List<AbilityGroup<?, ?>> getLockedByAbilities(String abilityName) {
        LinkedList abilities = new LinkedList();
        Entry entry = this.entries.get(abilityName);
        if (entry == null) {
            return abilities;
        }
        entry.lockedBy.forEach(dependencyName -> {
            AbilityGroup<?, ?> dependency = ModConfigs.ABILITIES.getAbilityGroupByName((String)dependencyName);
            abilities.add(dependency);
        });
        return abilities;
    }

    public List<AbilityGroup<?, ?>> getAbilitiesDependingOn(String abilityName) {
        LinkedList abilities = new LinkedList();
        AbilityGroup<?, ?> ability = ModConfigs.ABILITIES.getAbilityGroupByName(abilityName);
        for (AbilityGroup<?, ?> otherAbility : ModConfigs.ABILITIES.getAll()) {
            List<AbilityGroup<?, ?>> dependencies = ModConfigs.SKILL_GATES.getGates().getDependencyAbilities(otherAbility.getParentName());
            if (!dependencies.contains(ability)) continue;
            abilities.add(otherAbility);
        }
        return abilities;
    }

    public List<TalentGroup<?>> getDependencyTalents(String talentName) {
        LinkedList talents = new LinkedList();
        Entry entry = this.entries.get(talentName);
        if (entry == null) {
            return talents;
        }
        entry.dependsOn.forEach(dependencyName -> {
            TalentGroup<?> dependency = ModConfigs.TALENTS.getByName((String)dependencyName);
            talents.add(dependency);
        });
        return talents;
    }

    public List<TalentGroup<?>> getLockedByTalents(String talentName) {
        LinkedList talents = new LinkedList();
        Entry entry = this.entries.get(talentName);
        if (entry == null) {
            return talents;
        }
        entry.lockedBy.forEach(dependencyName -> {
            TalentGroup<?> dependency = ModConfigs.TALENTS.getByName((String)dependencyName);
            talents.add(dependency);
        });
        return talents;
    }

    public List<TalentGroup<?>> getTalentsDependingOn(String talentName) {
        LinkedList talents = new LinkedList();
        TalentGroup<?> talent = ModConfigs.TALENTS.getByName(talentName);
        for (TalentGroup<?> otherTalent : ModConfigs.TALENTS.getAll()) {
            List<TalentGroup<?>> dependencies = ModConfigs.SKILL_GATES.getGates().getDependencyTalents(otherTalent.getParentName());
            if (!dependencies.contains(talent)) continue;
            talents.add(otherTalent);
        }
        return talents;
    }

    public List<Research> getDependencyResearches(String researchName) {
        LinkedList<Research> researches = new LinkedList<Research>();
        Entry entry = this.entries.get(researchName);
        if (entry == null) {
            return researches;
        }
        entry.dependsOn.forEach(dependencyName -> {
            Research dependency = ModConfigs.RESEARCHES.getByName((String)dependencyName);
            researches.add(dependency);
        });
        return researches;
    }

    public List<Research> getLockedByResearches(String researchName) {
        LinkedList<Research> researches = new LinkedList<Research>();
        Entry entry = this.entries.get(researchName);
        if (entry == null) {
            return researches;
        }
        entry.lockedBy.forEach(dependencyName -> {
            Research dependency = ModConfigs.RESEARCHES.getByName((String)dependencyName);
            researches.add(dependency);
        });
        return researches;
    }

    public boolean isLocked(String researchName, ResearchTree researchTree) {
        SkillGates gates = ModConfigs.SKILL_GATES.getGates();
        List<String> researchesDone = researchTree.getResearchesDone();
        for (Research dependencyResearch : gates.getDependencyResearches(researchName)) {
            if (researchesDone.contains(dependencyResearch.getName())) continue;
            return true;
        }
        for (Research lockedByResearch : gates.getLockedByResearches(researchName)) {
            if (!researchesDone.contains(lockedByResearch.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isLocked(TalentGroup<?> talent, TalentTree talentTree) {
        SkillGates gates = ModConfigs.SKILL_GATES.getGates();
        for (TalentGroup<?> dependencyTalent : gates.getDependencyTalents(talent.getParentName())) {
            if (talentTree.getNodeOf(dependencyTalent).isLearned()) continue;
            return true;
        }
        for (TalentGroup<?> lockedByTalent : gates.getLockedByTalents(talent.getParentName())) {
            if (!talentTree.getNodeOf(lockedByTalent).isLearned()) continue;
            return true;
        }
        return false;
    }

    public boolean shouldDrawArrow(String entryA, String entryB) {
        Entry entry = this.entries.get(entryA);
        if (entry == null) {
            return false;
        }
        if (!entry.dependsOn.contains(entryB) && !entry.lockedBy.contains(entryB)) {
            return false;
        }
        return !entry.ignoreArrow;
    }

    public static class Entry {
        @Expose
        private List<String> dependsOn = new LinkedList<String>();
        @Expose
        private List<String> lockedBy = new LinkedList<String>();
        @Expose
        private boolean ignoreArrow;

        public void setDependsOn(String ... skills) {
            this.dependsOn.addAll(Arrays.asList(skills));
        }

        public void setLockedBy(String ... skills) {
            this.lockedBy.addAll(Arrays.asList(skills));
        }
    }
}

