/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.VaultLevelMessage;
import iskallia.vault.util.NetcodeUtils;
import iskallia.vault.world.data.EternalsData;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkDirection;

public class PlayerVaultStats
implements INBTSerializable<CompoundTag> {
    private final UUID uuid;
    private int vaultLevel;
    private int exp;
    private int unspentSkillPoints;
    private int unspentKnowledgePoints;
    private int unspentArchetypePoints;
    private int unspentRegretPoints;
    private int totalSpentSkillPoints;
    private int totalSpentKnowledgePoints;
    private int totalSpentArchetypePoints;
    private int totalSpentRegretPoints;

    public PlayerVaultStats(UUID uuid) {
        this.uuid = uuid;
    }

    public int getVaultLevel() {
        return this.vaultLevel;
    }

    public int getExp() {
        return this.exp;
    }

    public int getUnspentSkillPoints() {
        return this.unspentSkillPoints;
    }

    public int getUnspentKnowledgePoints() {
        return this.unspentKnowledgePoints;
    }

    public int getUnspentArchetypePoints() {
        return this.unspentArchetypePoints;
    }

    public int getUnspentRegretPoints() {
        return this.unspentRegretPoints;
    }

    public int getTotalSpentSkillPoints() {
        return this.totalSpentSkillPoints;
    }

    public int getTotalSpentKnowledgePoints() {
        return this.totalSpentKnowledgePoints;
    }

    public int getTotalSpentArchetypePoints() {
        return this.totalSpentArchetypePoints;
    }

    public int getTotalSpentRegretPoints() {
        return this.totalSpentRegretPoints;
    }

    public int getExpNeededToNextLevel() {
        if (this.getVaultLevel() >= ModConfigs.LEVELS_META.getMaxLevel()) {
            return 0;
        }
        return ModConfigs.LEVELS_META.getLevelMeta((int)this.vaultLevel).tnl;
    }

    public void setVaultLevel(MinecraftServer server, int level) {
        this.vaultLevel = Mth.m_14045_((int)level, (int)0, (int)ModConfigs.LEVELS_META.getMaxLevel());
        this.exp = 0;
        this.sync(server);
    }

    public void addVaultExp(MinecraftServer server, int exp) {
        int neededExp;
        int maxLevel = ModConfigs.LEVELS_META.getMaxLevel();
        if (this.getVaultLevel() >= maxLevel) {
            return;
        }
        this.exp = Math.max(this.exp, 0);
        this.exp += exp;
        int initialLevel = this.vaultLevel;
        while (this.exp >= (neededExp = this.getExpNeededToNextLevel())) {
            ++this.vaultLevel;
            ++this.unspentSkillPoints;
            this.exp -= neededExp;
            if (this.getVaultLevel() < maxLevel) continue;
            this.vaultLevel = maxLevel;
            this.exp = 0;
            break;
        }
        if (this.vaultLevel > initialLevel) {
            NetcodeUtils.runIfPresent(server, this.uuid, this::fancyLevelUpEffects);
            ServerPlayer player = server.m_6846_().m_11259_(this.uuid);
            if (player != null) {
                player.refreshTabListName();
            }
        }
        this.sync(server);
    }

    protected void fancyLevelUpEffects(ServerPlayer player) {
        ServerLevel world = player.m_183503_();
        Vec3 pos = player.m_20182_();
        for (int i = 0; i < 20; ++i) {
            double d0 = world.f_46441_.nextGaussian();
            double d1 = world.f_46441_.nextGaussian();
            double d2 = world.f_46441_.nextGaussian();
            world.m_8767_((ParticleOptions)ParticleTypes.f_123767_, pos.m_7096_() + world.f_46441_.nextDouble() - 0.5, pos.m_7098_() + world.f_46441_.nextDouble() - 0.5 + 3.0, pos.m_7094_() + world.f_46441_.nextDouble() - 0.5, 10, d0, d1, d2, 0.25);
        }
        world.m_5594_(null, player.m_142538_(), ModSounds.VAULT_LEVEL_UP_SFX, SoundSource.PLAYERS, 1.0f, 2.0f);
    }

    public void spendSkillPoints(MinecraftServer server, int amount) {
        this.unspentSkillPoints -= amount;
        this.totalSpentSkillPoints += amount;
        this.sync(server);
    }

    public void spendKnowledgePoints(MinecraftServer server, int amount) {
        this.unspentKnowledgePoints -= amount;
        this.totalSpentKnowledgePoints += amount;
        this.sync(server);
    }

    public void spendArchetypePoints(MinecraftServer server, int amount) {
        this.unspentArchetypePoints -= amount;
        this.totalSpentArchetypePoints += amount;
        this.sync(server);
    }

    public void spendRegretPoints(MinecraftServer server, int amount) {
        this.unspentRegretPoints -= amount;
        this.totalSpentRegretPoints += amount;
        this.sync(server);
    }

    public PlayerVaultStats reset(MinecraftServer server) {
        this.vaultLevel = 0;
        this.exp = 0;
        this.unspentSkillPoints = 0;
        this.unspentKnowledgePoints = 0;
        this.unspentArchetypePoints = 0;
        this.unspentRegretPoints = 0;
        this.sync(server);
        return this;
    }

    public PlayerVaultStats addSkillPoints(int amount) {
        this.unspentSkillPoints += amount;
        return this;
    }

    public PlayerVaultStats addKnowledgePoints(int amount) {
        this.unspentKnowledgePoints += amount;
        return this;
    }

    public PlayerVaultStats addArchetypePoints(int amount) {
        this.unspentArchetypePoints += amount;
        return this;
    }

    public PlayerVaultStats addRegretPoints(int amount) {
        this.unspentRegretPoints += amount;
        return this;
    }

    public void sync(MinecraftServer server) {
        NetcodeUtils.runIfPresent(server, this.uuid, player -> {
            ModNetwork.CHANNEL.sendTo((Object)new VaultLevelMessage(this.vaultLevel, this.exp, this.getExpNeededToNextLevel(), this.unspentSkillPoints, this.unspentKnowledgePoints, this.unspentArchetypePoints, this.unspentRegretPoints), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            EternalsData.get(server).m_77762_();
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("vaultLevel", this.vaultLevel);
        nbt.m_128405_("exp", this.exp);
        nbt.m_128405_("unspentSkillPts", this.unspentSkillPoints);
        nbt.m_128405_("unspentKnowledgePts", this.unspentKnowledgePoints);
        nbt.m_128405_("unspentArchetypePoints", this.unspentArchetypePoints);
        nbt.m_128405_("unspentRegretPoints", this.unspentRegretPoints);
        nbt.m_128405_("totalSpentSkillPoints", this.totalSpentSkillPoints);
        nbt.m_128405_("totalSpentKnowledgePoints", this.totalSpentKnowledgePoints);
        nbt.m_128405_("totalSpentArchetypePoints", this.totalSpentArchetypePoints);
        nbt.m_128405_("totalSpentRegretPoints", this.totalSpentRegretPoints);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.vaultLevel = nbt.m_128451_("vaultLevel");
        this.exp = nbt.m_128451_("exp");
        this.unspentSkillPoints = nbt.m_128451_("unspentSkillPts");
        this.unspentKnowledgePoints = nbt.m_128451_("unspentKnowledgePts");
        this.unspentArchetypePoints = nbt.m_128451_("unspentArchetypePoints");
        this.unspentRegretPoints = nbt.m_128451_("unspentRegretPoints");
        this.totalSpentSkillPoints = nbt.m_128451_("totalSpentSkillPoints");
        this.totalSpentKnowledgePoints = nbt.m_128451_("totalSpentKnowledgePoints");
        this.totalSpentArchetypePoints = nbt.m_128451_("totalSpentArchetypePoints");
        this.totalSpentRegretPoints = nbt.m_128451_("totalSpentRegretPoints");
    }
}

